/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects.mutagens;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.api.mutagens.MutagenData;
import xyz.yfrostyf.toxony.api.mutagens.MutagenEffect;
import xyz.yfrostyf.toxony.api.util.CompatibilityUtil;
import xyz.yfrostyf.toxony.network.ServerNightPredatorPacket;
import xyz.yfrostyf.toxony.network.SyncMutagenDataPacket;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.SoundEventRegistry;

public class BeastMutagenEffect
extends MutagenEffect {
    public static final String NIGHT_PREDATOR_ACTIVE = "night_predator_active";
    private static final AttributeModifier DAMAGEBOOST_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"wolf_mutagen_damage_modifier"), (double)0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"wolf_mutagen_speed_modifier"), (double)0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final String NATURE_SPELL_POWER = "nature_spell_power";
    private static final AttributeModifier NATURE_SPELLPOWER_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"nature_spell_power_modifier"), (double)0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public BeastMutagenEffect(MobEffectCategory category) {
        super(category, 0xFFFFFF);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        if (amplifier >= 1) {
            BeastMutagenEffect.addModifier(entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, DAMAGEBOOST_MODIFIER);
            Optional<Holder.Reference<Attribute>> ironsSpellOptional = CompatibilityUtil.getModAttribute(entity.level(), "irons_spellbooks", NATURE_SPELL_POWER);
            ironsSpellOptional.ifPresent(attribute -> BeastMutagenEffect.addModifier(entity, (Holder<Attribute>)((Holder)ironsSpellOptional.get()), NATURE_SPELLPOWER_MODIFIER));
        }
    }

    @Override
    public void removeModifiers(LivingEntity entity) {
        super.removeModifiers(entity);
        BeastMutagenEffect.removeModifier(entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, DAMAGEBOOST_MODIFIER);
        Optional<Holder.Reference<Attribute>> ironsSpellOptional = CompatibilityUtil.getModAttribute(entity.level(), "irons_spellbooks", NATURE_SPELL_POWER);
        ironsSpellOptional.ifPresent(attribute -> BeastMutagenEffect.removeModifier(entity, (Holder<Attribute>)((Holder)ironsSpellOptional.get()), NATURE_SPELLPOWER_MODIFIER));
        if (entity.hasEffect(MobEffectRegistry.BEAST_MUTAGEN) && entity.getEffect(MobEffectRegistry.BEAST_MUTAGEN).getAmplifier() >= 2) {
            BeastMutagenEffect.DeactivateNightPredator(entity, (MutagenData)entity.getData(DataAttachmentRegistry.MUTAGEN_DATA));
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MutagenData mutagenData = (MutagenData)livingEntity.getData(DataAttachmentRegistry.MUTAGEN_DATA);
        if (amplifier >= 2 && !livingEntity.level().isClientSide()) {
            if (!livingEntity.level().isDay() && !mutagenData.getBool(NIGHT_PREDATOR_ACTIVE)) {
                mutagenData.addBool(NIGHT_PREDATOR_ACTIVE, true);
                BeastMutagenEffect.ActivateNightPredator(livingEntity, mutagenData);
            } else if (livingEntity.level().isDay() && mutagenData.getBool(NIGHT_PREDATOR_ACTIVE)) {
                mutagenData.addBool(NIGHT_PREDATOR_ACTIVE, false);
                BeastMutagenEffect.DeactivateNightPredator(livingEntity, mutagenData);
            }
        }
        return true;
    }

    private static void ActivateNightPredator(LivingEntity livingEntity, MutagenData data) {
        Level level = livingEntity.level();
        BeastMutagenEffect.addModifier(livingEntity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, SPEED_MODIFIER);
        level.playSound(null, (Entity)livingEntity, (SoundEvent)SoundEventRegistry.MUTAGEN_TRANSFORM.get(), SoundSource.NEUTRAL, 0.8f, 2.0f);
        level.playSound(null, (Entity)livingEntity, SoundEvents.WOLF_GROWL, SoundSource.NEUTRAL, 0.8f, 0.9f);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer svplayer = (ServerPlayer)livingEntity;
            PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncMutagenDataPacket.create(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)ServerNightPredatorPacket.create(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void DeactivateNightPredator(LivingEntity livingEntity, MutagenData data) {
        Level level = livingEntity.level();
        BeastMutagenEffect.removeModifier(livingEntity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, SPEED_MODIFIER);
        level.playSound(null, (Entity)livingEntity, (SoundEvent)SoundEventRegistry.MUTAGEN_TRANSFORM.get(), SoundSource.NEUTRAL, 0.8f, 2.0f);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer svplayer = (ServerPlayer)livingEntity;
            PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncMutagenDataPacket.create(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)ServerNightPredatorPacket.create(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @EventBusSubscriber
    public static class BeastMutagenEvents {
        @SubscribeEvent
        public static void onDamageMutagenAttacker(LivingDamageEvent.Post event) {
            Entity entity;
            if (event.getSource().getEntity() == null || !((entity = event.getSource().getEntity()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity attackerEntity = (LivingEntity)entity;
            MobEffectInstance attackerMutagen = attackerEntity.getEffect(MobEffectRegistry.BEAST_MUTAGEN);
            MutagenData mutagenData = (MutagenData)attackerEntity.getData(DataAttachmentRegistry.MUTAGEN_DATA);
            if (attackerMutagen == null) {
                return;
            }
            if (attackerMutagen.getAmplifier() >= 0 && !attackerEntity.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                attackerEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 40, 0));
            }
            if (attackerMutagen.getAmplifier() >= 2 && mutagenData.getBool(BeastMutagenEffect.NIGHT_PREDATOR_ACTIVE) && !event.getEntity().level().isClientSide()) {
                event.getEntity().addEffect(new MobEffectInstance(MobEffectRegistry.HUNT, 100, 0));
                attackerEntity.playSound(SoundEvents.WOLF_GROWL, 6.0f, 1.0f);
            }
        }

        @SubscribeEvent
        public static void onEatingAsBeast(LivingEntityUseItemEvent.Finish event) {
            ItemStack foodstack = event.getItem();
            LivingEntity livingEntity = event.getEntity();
            MobEffectInstance attackerMutagen = livingEntity.getEffect(MobEffectRegistry.BEAST_MUTAGEN);
            if (attackerMutagen != null && attackerMutagen.getAmplifier() >= 1) {
                if (!foodstack.has(DataComponents.FOOD)) {
                    return;
                }
                if (foodstack.is(Tags.Items.FOODS_COOKED_MEAT) || foodstack.is(Tags.Items.FOODS_COOKED_FISH)) {
                    FoodProperties foodProperties = (FoodProperties)foodstack.get(DataComponents.FOOD);
                    livingEntity.eat(livingEntity.level(), foodstack, new FoodProperties(foodProperties.nutrition() / 2, foodProperties.saturation() / 2.0f, foodProperties.canAlwaysEat(), foodProperties.eatSeconds(), foodProperties.usingConvertsTo(), foodProperties.effects()));
                } else if (foodstack.is(Tags.Items.FOODS_RAW_MEAT) || foodstack.is(Tags.Items.FOODS_RAW_FISH)) {
                    FoodProperties foodProperties = (FoodProperties)foodstack.get(DataComponents.FOOD);
                    livingEntity.eat(livingEntity.level(), foodstack, new FoodProperties(foodProperties.nutrition() * 2, foodProperties.saturation() * 2.0f, foodProperties.canAlwaysEat(), foodProperties.eatSeconds(), foodProperties.usingConvertsTo(), foodProperties.effects()));
                }
            }
        }
    }
}

