/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects.mutagens;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import xyz.yfrostyf.toxony.api.mutagens.MutagenEffect;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;

public class HollowMutagenEffect
extends MutagenEffect {
    private static final AttributeModifier MOVEEFFICIENCY_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"hollow_mutagen_moveeff_modifier"), 1.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"hollow_mutagen_knockbackresist_add"), (double)0.2f, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier KNOCKBACK_ENHANCED_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"hollow_mutagen_knockbackresist_add"), (double)0.3f, AttributeModifier.Operation.ADD_VALUE);
    private static final float SPIDER_CLIMB_RATE = 0.1f;

    public HollowMutagenEffect(MobEffectCategory category) {
        super(category, 0xFFFFFF);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        HollowMutagenEffect.addModifier(entity, (Holder<Attribute>)Attributes.MOVEMENT_EFFICIENCY, MOVEEFFICIENCY_MODIFIER);
        HollowMutagenEffect.addModifier(entity, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, KNOCKBACK_MODIFIER);
        if (amplifier >= 2) {
            HollowMutagenEffect.addModifier(entity, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, KNOCKBACK_ENHANCED_MODIFIER);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (amplifier >= 2) {
            if (entity.horizontalCollision) {
                entity.fallDistance = 0.0f;
                float maxVel = 0.15f;
                Vec3 deltaMovement = entity.getDeltaMovement();
                double velX = Math.clamp(deltaMovement.x, (double)-0.15f, (double)0.15f);
                double velY = 0.1f;
                double velZ = Math.clamp(deltaMovement.z, (double)-0.15f, (double)0.15f);
                if (entity.isSuppressingSlidingDownLadder()) {
                    velY = 0.0;
                }
                entity.setDeltaMovement(velX, velY, velZ);
            }
            if (entity.tickCount % 20 == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 240, 0, false, false, false));
                if (HollowMutagenEffect.isUnderSunTick(entity.level(), entity)) {
                    entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 0, true, false, false));
                }
            }
        }
        return true;
    }

    private static boolean isUnderSunTick(Level level, LivingEntity entity) {
        if (level.isDay() && !level.isClientSide) {
            boolean flag;
            float f = entity.getLightLevelDependentMagicValue();
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ());
            boolean bl = flag = entity.isInWaterRainOrBubble() || entity.isInPowderSnow || entity.wasInPowderSnow;
            if (f > 0.5f && !flag && level.canSeeSky(blockpos)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeModifiers(LivingEntity entity) {
        super.removeModifiers(entity);
        HollowMutagenEffect.removeModifier(entity, (Holder<Attribute>)Attributes.MOVEMENT_EFFICIENCY, MOVEEFFICIENCY_MODIFIER);
        HollowMutagenEffect.removeModifier(entity, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, KNOCKBACK_MODIFIER);
        HollowMutagenEffect.removeModifier(entity, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, KNOCKBACK_ENHANCED_MODIFIER);
    }

    @EventBusSubscriber
    public static class HollowMutagenEvents {
        @SubscribeEvent
        public static void onHollowDamaged(LivingDamageEvent.Pre event) {
            LivingEntity livingEntity = event.getEntity();
            MobEffectInstance victimMutagen = livingEntity.getEffect(MobEffectRegistry.HOLLOW_MUTAGEN);
            if (victimMutagen == null) {
                return;
            }
            if (victimMutagen.getAmplifier() >= 1) {
                event.setNewDamage(event.getOriginalDamage() * 0.85f);
            }
        }
    }
}

