/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects.mutagens;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import xyz.yfrostyf.toxony.api.mutagens.MutagenEffect;
import xyz.yfrostyf.toxony.api.util.CompatibilityUtil;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;

public class InfernalMutagenEffect
extends MutagenEffect {
    private static List<SmeltingRecipe> charcoalRecipeCache = null;
    private static final String FIRE_SPELL_POWER = "fire_spell_power";
    private static final AttributeModifier FIRE_SPELLPOWER_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"fire_spell_power_modifier"), (double)0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public InfernalMutagenEffect(MobEffectCategory category) {
        super(category, 0xFFFFFF);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectAdded(entity, amplifier);
        if (amplifier >= 1) {
            Optional<Holder.Reference<Attribute>> ironsSpellOptional = CompatibilityUtil.getModAttribute(entity.level(), "irons_spellbooks", FIRE_SPELL_POWER);
            ironsSpellOptional.ifPresent(attribute -> InfernalMutagenEffect.addModifier(entity, (Holder<Attribute>)((Holder)ironsSpellOptional.get()), FIRE_SPELLPOWER_MODIFIER));
        }
    }

    @Override
    public void removeModifiers(LivingEntity entity) {
        super.removeModifiers(entity);
        Optional<Holder.Reference<Attribute>> ironsSpellOptional = CompatibilityUtil.getModAttribute(entity.level(), "irons_spellbooks", FIRE_SPELL_POWER);
        ironsSpellOptional.ifPresent(attribute -> InfernalMutagenEffect.removeModifier(entity, (Holder<Attribute>)((Holder)ironsSpellOptional.get()), FIRE_SPELLPOWER_MODIFIER));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (amplifier >= 2) {
            entity.clearFire();
            if (entity.tickCount % 20 == 0 && entity.isInWaterRainOrBubble()) {
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 0, true, false, false));
            }
        }
        return true;
    }

    @EventBusSubscriber
    public static class InfernalMutagenEvents {
        @SubscribeEvent
        public static void onMutagenDamaged(LivingDamageEvent.Pre event) {
            MobEffectInstance victimMutagen = event.getEntity().getEffect(MobEffectRegistry.INFERNAL_MUTAGEN);
            Holder damageType = event.getSource().typeHolder();
            if (victimMutagen != null) {
                Entity entity;
                if (victimMutagen.getAmplifier() >= 0 && victimMutagen.getAmplifier() < 2 && damageType.is(DamageTypes.ON_FIRE)) {
                    event.setNewDamage(event.getOriginalDamage() * 0.5f);
                }
                if (victimMutagen.getAmplifier() >= 1 && (entity = event.getSource().getEntity()) instanceof LivingEntity) {
                    LivingEntity attackerEntity = (LivingEntity)entity;
                    attackerEntity.igniteForSeconds(6.0f);
                }
                if (victimMutagen.getAmplifier() >= 2 && damageType.is(DamageTypeTags.IS_FIRE)) {
                    event.setNewDamage(0.0f);
                }
            }
        }

        @SubscribeEvent
        public static void onDamageMutagenAttacker(LivingDamageEvent.Post event) {
            LivingEntity attackerEntity;
            MobEffectInstance attackerMutagen;
            LivingEntity victimEntity = event.getEntity();
            Entity entity = event.getSource().getEntity();
            if (entity instanceof LivingEntity && (attackerMutagen = (attackerEntity = (LivingEntity)entity).getEffect(MobEffectRegistry.INFERNAL_MUTAGEN)) != null && attackerMutagen.getAmplifier() >= 1) {
                victimEntity.igniteForSeconds(6.0f);
            }
        }

        @SubscribeEvent
        public static void onRightClickItemStack(PlayerInteractEvent.RightClickItem event) {
            if (!event.getEntity().isCrouching()) {
                return;
            }
            MobEffectInstance mutagen = event.getEntity().getEffect(MobEffectRegistry.INFERNAL_MUTAGEN);
            if (mutagen == null || mutagen.getAmplifier() < 1) {
                return;
            }
            boolean matched = false;
            if (charcoalRecipeCache == null) {
                RecipeManager recipeManager = event.getEntity().level().getRecipeManager();
                charcoalRecipeCache = recipeManager.getAllRecipesFor(RecipeType.SMELTING).stream().filter(holder -> ((SmeltingRecipe)holder.value()).getResultItem(null).is(Items.CHARCOAL)).map(RecipeHolder::value).toList();
            }
            for (SmeltingRecipe recipe : charcoalRecipeCache) {
                if (!((Ingredient)recipe.getIngredients().getFirst()).test(event.getItemStack())) continue;
                matched = true;
                break;
            }
            if (matched) {
                SmeltingRecipe recipe;
                event.getItemStack().consume(1, (LivingEntity)event.getEntity());
                event.getEntity().getInventory().add(new ItemStack((ItemLike)Items.CHARCOAL, 1));
                recipe = event.getEntity().level();
                if (recipe instanceof ServerLevel) {
                    ServerLevel svlevel = (ServerLevel)recipe;
                    Vec3 vec3 = event.getEntity().getViewVector(1.0f);
                    Vector3f vector3foffset = vec3.toVector3f().rotate((Quaternionfc)new Quaternionf().setAngleAxis(0.19198621809482574, vec3.x, vec3.y, vec3.z));
                    svlevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, event.getEntity().getX() + (double)vector3foffset.x, event.getEntity().getEyeY() - (double)0.3f + (double)vector3foffset.y, event.getEntity().getZ() + (double)vector3foffset.z, 6, 0.05, 0.05, 0.05, 0.02);
                    svlevel.playSound(null, (Entity)event.getEntity(), SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
        }
    }
}

