/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects.mutagens;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import xyz.yfrostyf.toxony.api.mutagens.MutagenData;
import xyz.yfrostyf.toxony.api.mutagens.MutagenEffect;
import xyz.yfrostyf.toxony.api.util.CompatibilityUtil;
import xyz.yfrostyf.toxony.entities.GuidedSpiritEntity;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.EntityRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class SpiritMutagenEffect
extends MutagenEffect {
    public static final String GUIDED_SPIRIT_ACTIVE = "guided_spirit_active";
    public static final String GUIDED_SPIRIT_COOLDOWN = "guided_spirit_cooldown";
    public static final int DEFAULT_GUIDED_SPIRIT_COOLDOWN = 400;
    private static final AttributeModifier FALL_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"spirit_mutagen_fall_modifier"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final String EVOCATION_SPELL_POWER = "evocation_spell_power";
    private static final AttributeModifier EVOCATION_SPELLPOWER_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"evocation_spell_power_modifier"), (double)0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public SpiritMutagenEffect(MobEffectCategory category) {
        super(category, 0xFFFFFF);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        if (amplifier >= 0) {
            SpiritMutagenEffect.addModifier(entity, (Holder<Attribute>)Attributes.FALL_DAMAGE_MULTIPLIER, FALL_MODIFIER);
        }
        if (amplifier >= 1) {
            Optional<Holder.Reference<Attribute>> ironsSpellOptional = CompatibilityUtil.getModAttribute(entity.level(), "irons_spellbooks", EVOCATION_SPELL_POWER);
            ironsSpellOptional.ifPresent(attribute -> SpiritMutagenEffect.addModifier(entity, (Holder<Attribute>)((Holder)ironsSpellOptional.get()), EVOCATION_SPELLPOWER_MODIFIER));
        }
    }

    @Override
    public void removeModifiers(LivingEntity entity) {
        super.removeModifiers(entity);
        SpiritMutagenEffect.removeModifier(entity, (Holder<Attribute>)Attributes.FALL_DAMAGE_MULTIPLIER, FALL_MODIFIER);
        Optional<Holder.Reference<Attribute>> ironsSpellOptional = CompatibilityUtil.getModAttribute(entity.level(), "irons_spellbooks", EVOCATION_SPELL_POWER);
        ironsSpellOptional.ifPresent(attribute -> SpiritMutagenEffect.removeModifier(entity, (Holder<Attribute>)((Holder)ironsSpellOptional.get()), EVOCATION_SPELLPOWER_MODIFIER));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MutagenData mutagenData = (MutagenData)livingEntity.getData(DataAttachmentRegistry.MUTAGEN_DATA);
        if (amplifier >= 1 && !livingEntity.level().isClientSide && !mutagenData.getBool(GUIDED_SPIRIT_ACTIVE)) {
            int cooldown = mutagenData.getInt(GUIDED_SPIRIT_COOLDOWN);
            mutagenData.addInt(GUIDED_SPIRIT_COOLDOWN, cooldown - 1);
            if (cooldown <= 0) {
                mutagenData.addBool(GUIDED_SPIRIT_ACTIVE, true);
            }
        }
        if (amplifier >= 2) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 40, 0, true, false, false));
        }
        return true;
    }

    @EventBusSubscriber
    public static class SpiritMutagenEvents {
        @SubscribeEvent
        public static void onMutagenDamaged(LivingDamageEvent.Pre event) {
            boolean isDirectSpirt;
            MobEffectInstance victimMutagen = event.getEntity().getEffect(MobEffectRegistry.SPIRIT_MUTAGEN);
            Entity causingIndirectEntity = event.getSource().getEntity();
            Entity causingEntity = event.getSource().getDirectEntity();
            if (victimMutagen == null || event.getEntity().level().isClientSide()) {
                return;
            }
            LivingEntity victim = event.getEntity();
            Holder damageType = event.getSource().typeHolder();
            float newDamage = event.getOriginalDamage();
            boolean isIndirectSpirt = causingIndirectEntity != null && causingIndirectEntity.getType().is(TagRegistry.SPIRIT_RESISTANT);
            boolean bl = isDirectSpirt = causingEntity != null && causingEntity.getType().is(TagRegistry.SPIRIT_RESISTANT);
            if (isIndirectSpirt || isDirectSpirt || damageType.is(DamageTypeTags.IS_FALL)) {
                newDamage *= 0.5f;
            }
            if (!(victimMutagen.getAmplifier() < 1 || victim.level().isClientSide() || damageType.is(DamageTypeTags.WITCH_RESISTANT_TO) || damageType.is(DamageTypeTags.IS_FIRE) || event.getEntity().getRandom().nextInt(5) != 0)) {
                victim.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 200, 0, false, false, false));
                newDamage *= 0.0f;
            }
            if (victimMutagen.getAmplifier() >= 2 && damageType.is(DamageTypeTags.WITCH_RESISTANT_TO)) {
                newDamage *= 1.3f;
            }
            event.setNewDamage(newDamage);
        }

        @SubscribeEvent
        public static void onDamageMutagenAttacker(LivingDamageEvent.Post event) {
            Entity entity;
            if (event.getSource().getEntity() == null || !((entity = event.getSource().getEntity()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity attackerEntity = (LivingEntity)entity;
            MobEffectInstance attackerMutagen = attackerEntity.getEffect(MobEffectRegistry.SPIRIT_MUTAGEN);
            Level level = attackerEntity.level();
            if (attackerMutagen == null || !(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel svlevel = (ServerLevel)level;
            MutagenData mutagenData = (MutagenData)attackerEntity.getData(DataAttachmentRegistry.MUTAGEN_DATA);
            if (mutagenData.getBool(SpiritMutagenEffect.GUIDED_SPIRIT_ACTIVE)) {
                if (attackerMutagen.getAmplifier() == 1) {
                    GuidedSpiritEntity spirit = (GuidedSpiritEntity)((EntityType)EntityRegistry.GUIDED_SPIRIT.get()).create(level);
                    BlockPos pos = attackerEntity.blockPosition();
                    if (spirit != null) {
                        spirit.initSummon(attackerEntity, attackerEntity.getX(), attackerEntity.getEyeY(), attackerEntity.getZ(), 1);
                        spirit.setBoundOrigin(pos);
                        svlevel.addFreshEntity((Entity)spirit);
                        svlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, pos, GameEvent.Context.of((Entity)attackerEntity));
                    }
                } else if (attackerMutagen.getAmplifier() >= 2) {
                    for (int i = 0; i < 3; ++i) {
                        GuidedSpiritEntity spirit = (GuidedSpiritEntity)((EntityType)EntityRegistry.GUIDED_SPIRIT.get()).create(level);
                        BlockPos pos = attackerEntity.blockPosition();
                        if (spirit == null) continue;
                        spirit.initSummon(attackerEntity, attackerEntity.getX(), attackerEntity.getEyeY(), attackerEntity.getZ(), i);
                        spirit.setBoundOrigin(pos);
                        svlevel.addFreshEntity((Entity)spirit);
                        svlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, pos, GameEvent.Context.of((Entity)attackerEntity));
                    }
                }
                if (attackerMutagen.getAmplifier() >= 1) {
                    mutagenData.addBool(SpiritMutagenEffect.GUIDED_SPIRIT_ACTIVE, false);
                    mutagenData.addInt(SpiritMutagenEffect.GUIDED_SPIRIT_COOLDOWN, 400);
                }
            }
        }
    }
}

