/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.entities;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import xyz.yfrostyf.toxony.registries.ParticleRegistry;

public class GuidedSpiritEntity
extends PathfinderMob
implements TraceableEntity,
FlyingAnimal {
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)1.2f;
    LivingEntity owner;
    private BlockPos boundOrigin;
    private boolean hasLimitedLife;
    private int limitedLifeTicks;

    public GuidedSpiritEntity(EntityType<GuidedSpiritEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FLYING_SPEED, (double)0.8f).add(Attributes.MOVEMENT_SPEED, (double)0.8f).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new GuidedSpiritOwnerTargetGoal(this, (Mob)this, this.getOwner()));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
    }

    public void initSummon(LivingEntity owner, double x, double y, double z, int index) {
        this.moveTo(owner.position(), 0.0f, 0.0f);
        Vec3 ownerViewVec3 = owner.getViewVector(1.0f);
        Vec3 ownerUpVec3 = owner.getUpVector(1.0f);
        Vec3 ownerPerpViewVec3 = ownerViewVec3.cross(ownerUpVec3);
        Vector3f pushVec3 = ownerViewVec3.toVector3f().normalize();
        pushVec3.mul(0.2f);
        pushVec3.rotate((Quaternionfc)new Quaternionf().setAngleAxis(1.5707963267948966, ownerPerpViewVec3.x, ownerPerpViewVec3.y, ownerPerpViewVec3.z));
        pushVec3.rotate((Quaternionfc)new Quaternionf().setAngleAxis(1.0471975511965976, ownerViewVec3.x, ownerViewVec3.y, ownerViewVec3.z));
        pushVec3.rotate((Quaternionfc)new Quaternionf().setAngleAxis(-1.0471975511965976 * (double)index, ownerViewVec3.x, ownerViewVec3.y, ownerViewVec3.z));
        this.setOwner(owner);
        this.setLimitedLife(20 * (10 + owner.getRandom().nextInt(5)));
        this.moveTo(x, y, z, 0.0f, 0.0f);
        this.push(pushVec3.x, pushVec3.y, pushVec3.z);
    }

    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
        if (this.hasLimitedLife && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.hurt(this.damageSources().starve(), this.getMaxHealth());
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.random.nextInt(40) == 0) {
            this.playSound(SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, 0.6f, 1.5f);
        }
    }

    protected AABB getAttackBoundingBox() {
        AABB aabb = this.getBoundingBox();
        return aabb.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    public boolean doHurtTarget(Entity entity) {
        boolean hurtTarget = super.doHurtTarget(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (hurtTarget) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 0, true, true, true));
            }
        }
        this.hurt(this.damageSources().starve(), this.getMaxHealth());
        return hurtTarget;
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.setInvisible(true);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUIDED_SPIRIT_RELEASE.get()), this.getX(), this.getEyeY() + 0.5, this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return super.getDeathSound();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOrigin) {
        this.boundOrigin = boundOrigin;
    }

    public void setLimitedLife(int limitedLifeTicks) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = limitedLifeTicks;
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation(this, (Mob)this, level){

            public boolean isStableDestination(BlockPos pos) {
                return !this.level.getBlockState(pos.below()).isAir();
            }
        };
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof GuidedSpiritEntity) {
            GuidedSpiritEntity spirit = (GuidedSpiritEntity)entity;
            this.owner = spirit.getOwner();
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("BoundX")) {
            this.boundOrigin = new BlockPos(compound.getInt("BoundX"), compound.getInt("BoundY"), compound.getInt("BoundZ"));
        }
        if (compound.contains("LifeTicks")) {
            this.setLimitedLife(compound.getInt("LifeTicks"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.boundOrigin != null) {
            compound.putInt("BoundX", this.boundOrigin.getX());
            compound.putInt("BoundY", this.boundOrigin.getY());
            compound.putInt("BoundZ", this.boundOrigin.getZ());
        }
        if (this.hasLimitedLife) {
            compound.putInt("LifeTicks", this.limitedLifeTicks);
        }
    }

    public boolean isFlying() {
        return true;
    }

    class GuidedSpiritOwnerTargetGoal
    extends TargetGoal {
        private final LivingEntity owner;
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public GuidedSpiritOwnerTargetGoal(GuidedSpiritEntity this$0, Mob mob, LivingEntity owner) {
            super(mob, false);
            this.owner = owner;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            if (this.owner == null) {
                return false;
            }
            this.ownerLastHurt = this.owner.getLastHurtMob();
            int i = this.owner.getLastHurtMobTimestamp();
            return i != this.timestamp && this.canAttack(this.ownerLastHurt, TargetingConditions.DEFAULT);
        }

        public void start() {
            if (this.owner != null) {
                this.mob.setTarget(this.ownerLastHurt);
                this.timestamp = this.owner.getLastHurtMobTimestamp();
            }
            super.start();
        }
    }
}

