/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.entities.item;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.EntityRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class Bolt
extends AbstractArrow {
    public Bolt(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(1.0);
    }

    public Bolt(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super((EntityType)EntityRegistry.BOLT.get(), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(1.0);
    }

    public Bolt(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super((EntityType)EntityRegistry.BOLT.get(), owner, level, pickupItemStack, firedFromWeapon);
        this.setBaseDamage(1.0);
    }

    private ItemOil getOilContents() {
        return (ItemOil)this.getPickupItemStackOrigin().getOrDefault(DataComponentsRegistry.OIL, (Object)ItemOil.EMPTY);
    }

    private PotionContents getPotionContents() {
        return (PotionContents)this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    private void setPotionContents(PotionContents potionContents) {
        this.getPickupItemStackOrigin().set(DataComponents.POTION_CONTENTS, (Object)potionContents);
    }

    public void addEffect(MobEffectInstance effectInstance) {
        this.setPotionContents(this.getPotionContents().withEffectAdded(effectInstance));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.getPotionContents().equals((Object)PotionContents.EMPTY) && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent((Entity)this, (byte)0);
            this.setPickupItemStack(new ItemStack((ItemLike)Items.ARROW));
        }
    }

    private void makeParticle(int particleAmount) {
        if (particleAmount > 0) {
            for (int j = 0; j < particleAmount; ++j) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)1), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void doPostHurtEffects(LivingEntity living) {
        PotionContents potioncontents;
        super.doPostHurtEffects(living);
        ItemOil itemoil = this.getOilContents();
        if (!itemoil.isEmpty()) {
            for (Holder<MobEffect> holder : itemoil.getOil().getEffects()) {
                if (((MobEffect)holder.value()).isInstantenous()) {
                    ((MobEffect)holder.value()).applyInstantenousEffect(this.getEffectSource(), this.getEffectSource(), living, itemoil.amplifier(), 1.0);
                    continue;
                }
                living.addEffect(new MobEffectInstance(holder, itemoil.duration(), itemoil.amplifier()), this.getEffectSource());
            }
        }
        if ((potioncontents = this.getPotionContents()).potion().isPresent()) {
            for (MobEffectInstance mobeffectinstance : ((Potion)((Holder)potioncontents.potion().get()).value()).getEffects()) {
                if (((MobEffect)mobeffectinstance.getEffect().value()).isInstantenous()) {
                    ((MobEffect)mobeffectinstance.getEffect().value()).applyInstantenousEffect(this.getEffectSource(), this.getEffectSource(), living, itemoil.amplifier(), 1.0);
                    continue;
                }
                living.addEffect(new MobEffectInstance(mobeffectinstance.getEffect(), mobeffectinstance.getDuration(), mobeffectinstance.getAmplifier(), mobeffectinstance.isAmbient(), mobeffectinstance.isVisible()), this.getEffectSource());
            }
        }
        for (MobEffectInstance mobeffectinst : potioncontents.customEffects()) {
            living.addEffect(mobeffectinst, this.getEffectSource());
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(ItemRegistry.BOLT);
    }
}

