/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.entities.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.api.util.CompatibilityUtil;
import xyz.yfrostyf.toxony.damages.FlailDamageSource;
import xyz.yfrostyf.toxony.items.weapons.FlailItem;
import xyz.yfrostyf.toxony.registries.EntityRegistry;

public class FlailBall
extends Projectile {
    public static final int FLAIL_LIFETIME = 20;
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(FlailBall.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final double MAX_RANGE = 160.0;
    private final RandomSource syncronizedRandom = RandomSource.create();
    protected float damage;
    protected float impactPercent;
    protected boolean isCharged;
    @Nullable
    protected ItemOil oil;
    private int life;
    private boolean isFlying;

    public FlailBall(EntityType<? extends FlailBall> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
        this.damage = 0.0f;
        this.isCharged = false;
        this.impactPercent = 0.0f;
        this.oil = null;
        this.entityData.set(ID_FOIL, (Object)false);
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose);
    }

    public FlailBall(Player player, Level level, ItemStack stack, int force, float damage, boolean isCharged, float impactPercent, ItemOil oil) {
        this((EntityType<? extends FlailBall>)((EntityType)EntityRegistry.FLAIL_BALL.get()), level);
        this.entityData.set(ID_FOIL, (Object)stack.hasFoil());
        this.damage = damage;
        this.isCharged = isCharged;
        this.impactPercent = impactPercent;
        this.oil = oil;
        this.setOwner((Entity)player);
        float f = player.getXRot();
        float f1 = player.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.getX() - (double)f3 * 0.3;
        double d1 = player.getEyeY();
        double d2 = player.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3.scale(1.0 + (double)(force - 1) * 0.25));
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ID_FOIL, (Object)false);
    }

    public void tick() {
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        super.tick();
        Entity entity = this.getOwner();
        if (!(entity instanceof Player)) {
            this.discard();
        } else {
            Player player = (Player)entity;
            if (FlailItem.isUsingFlail((LivingEntity)player) || this.distanceToSqr((Entity)player) > 160.0) {
                this.discard();
                return;
            }
            if (this.onGround()) {
                ++this.life;
                if (this.life >= 20) {
                    this.discard();
                    return;
                }
            } else {
                this.isFlying = true;
                this.life = 0;
            }
            if (this.isFlying) {
                this.checkCollision();
            }
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -this.getDefaultGravity(), 0.0));
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.updateRotation();
            if (this.isFlying && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3.ZERO);
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.reapplyPosition();
        }
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }

    private void checkCollision() {
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (hitresult.getType() == HitResult.Type.MISS || !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
    }

    protected void onHit(HitResult result) {
        HitResult.Type hitresult$type = result.getType();
        if (hitresult$type == HitResult.Type.ENTITY) {
            EntityHitResult entityhitresult = (EntityHitResult)result;
            this.onHitEntity(entityhitresult);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, result.getLocation(), GameEvent.Context.of((Entity)this, null));
        } else if (result.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)result;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.getBlockPos();
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockpos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockpos)));
        }
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        this.setDeltaMovement(Vec3.ZERO);
        if (!this.level().isClientSide && entity != this.getOwner()) {
            entity.hurt((DamageSource)new FlailDamageSource((Holder<DamageType>)this.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(DamageTypes.GENERIC), this.getOwner()), CompatibilityUtil.modifyDamageFromSilver(entity, this.damage));
            this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 0.8f);
            if (this.isCharged) {
                this.blastHit(this.getOwner(), entity);
                this.playSound(SoundEvents.FIREWORK_ROCKET_BLAST, 1.0f, 0.6f);
                ServerLevel svlevel = (ServerLevel)this.level();
                svlevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.applyOilEffects(this.oil, livingEntity);
        }
    }

    private void applyOilEffects(@Nullable ItemOil itemOil, LivingEntity target) {
        if (itemOil == null) {
            return;
        }
        for (Holder<MobEffect> holder : itemOil.getOil().getEffects()) {
            MobEffectInstance mobeffectInst = new MobEffectInstance(holder, itemOil.duration(), itemOil.amplifier());
            if (((MobEffect)holder.value()).isInstantenous()) {
                ((MobEffect)holder.value()).applyInstantenousEffect((Entity)this, this.getOwner(), target, mobeffectInst.getAmplifier(), (double)target.getHealth());
                continue;
            }
            MobEffectInstance modifedMobEffectInstance = new MobEffectInstance(holder, mobeffectInst.getDuration(), mobeffectInst.getAmplifier(), mobeffectInst.isAmbient(), mobeffectInst.isVisible());
            if (modifedMobEffectInstance.endsWithin(20)) continue;
            target.addEffect(modifedMobEffectInstance, this.getEffectSource());
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(result.distanceTo((Entity)this)));
    }

    protected void blastHit(Entity owner, Entity target) {
        float radius = 3.0f;
        int k1 = Mth.floor((double)(this.getX() - (double)radius - 1.0));
        int l1 = Mth.floor((double)(this.getX() + (double)radius + 1.0));
        int i2 = Mth.floor((double)(this.getY() - (double)radius - 1.0));
        int i1 = Mth.floor((double)(this.getY() + (double)radius + 1.0));
        int j2 = Mth.floor((double)(this.getZ() - (double)radius - 1.0));
        int j1 = Mth.floor((double)(this.getZ() + (double)radius + 1.0));
        List list = this.level().getEntities((Entity)this, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        Vec3 vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
        for (Entity entity : list) {
            double d9;
            double d7;
            double d5;
            double d12;
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            double d11 = Math.sqrt(entity.distanceToSqr(vec3)) / (double)radius;
            if (!(d11 <= 1.0) || (d12 = Math.sqrt((d5 = entity.getX() - this.getX()) * d5 + (d7 = entity.getEyeY() - this.getY()) * d7 + (d9 = entity.getZ() - this.getZ()) * d9)) == 0.0) continue;
            d5 /= d12;
            d7 /= d12;
            d9 /= d12;
            Holder.Reference damageType = this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.THROWN);
            if (!entity.is(target)) {
                entity.hurt((DamageSource)new FlailDamageSource((Holder<DamageType>)damageType, owner), this.damage * this.impactPercent);
            }
            double d13 = (1.0 - d11) * (double)Explosion.getSeenPercent((Vec3)vec3, (Entity)entity);
            Vec3 vec31 = new Vec3(d5 *= d13, d7 *= d13, d9 *= d13);
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec31));
        }
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }
}

