/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.entities.item;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import xyz.yfrostyf.toxony.api.util.CompatibilityUtil;
import xyz.yfrostyf.toxony.registries.EntityRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;

public class FlintlockBall
extends Projectile
implements ItemSupplier {
    public static final int BALL_LIFETIME = 80;
    private int life = 0;
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(FlintlockBall.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private int acidLevel = 0;
    private float damage = 0.0f;
    private ItemStack item;

    public FlintlockBall(EntityType<? extends FlintlockBall> entityType, Level level) {
        super(entityType, level);
    }

    public FlintlockBall(Level level, ItemStack item, float damage, int acidLevel) {
        this((EntityType<? extends FlintlockBall>)((EntityType)EntityRegistry.FLINTLOCK_BALL.get()), level);
        this.damage = damage;
        this.acidLevel = acidLevel;
        this.item = item;
    }

    public void shoot(LivingEntity shooter, double x, double y, double z, float velocity, float inaccuracy) {
        this.setOwner((Entity)shooter);
        this.setPos(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        Vec3 vec3 = this.getMovementToShoot(x, y, z, velocity, inaccuracy);
        this.setDeltaMovement(vec3);
        this.hasImpulse = true;
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        super.shoot(x, y, z, velocity, inaccuracy);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 128.0) * d0;
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return true;
    }

    public void tick() {
        float f;
        super.tick();
        ++this.life;
        if (this.life >= 80) {
            this.discard();
            return;
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.setDeltaMovement(vec3.scale((double)f));
        this.applyGravity();
        this.setPos(d0, d1, d2);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity livingEntity;
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        Entity entity2 = this.getOwner();
        entity.hurt(this.damageSources().mobProjectile((Entity)this, entity2 instanceof LivingEntity ? (livingEntity = (LivingEntity)entity2) : null), CompatibilityUtil.modifyDamageFromSilver(entity, this.damage));
        if (this.acidLevel > 0 && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffectRegistry.ACID, this.acidLevel * 80, 0));
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public void setItem(ItemStack stack) {
        this.getEntityData().set(DATA_ITEM_STACK, (Object)stack.copyWithCount(1));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM_STACK, (Object)this.getDefaultItem());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("Item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Item", 10)) {
            this.setItem(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("Item")).orElseGet(this::getDefaultItem));
        } else {
            this.setItem(this.getDefaultItem());
        }
    }

    protected double getDefaultGravity() {
        return 0.005;
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM_STACK);
    }

    public ItemStack getDefaultItem() {
        return ((Item)ItemRegistry.IRON_ROUND.get()).getDefaultInstance();
    }
}

