/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.entities.item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.EntityRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.OilsRegistry;
import xyz.yfrostyf.toxony.registries.ParticleRegistry;

public class ThrownOilPot
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    private ItemStack itemStack;

    public ThrownOilPot(EntityType<? extends ThrownOilPot> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownOilPot(Level level, LivingEntity shooter, ItemStack itemStack) {
        super((EntityType)EntityRegistry.OIL_POT.get(), shooter, level);
        this.itemStack = itemStack;
    }

    public ThrownOilPot(Level level, ItemStack itemStack, double x, double y, double z) {
        super((EntityType)EntityRegistry.OIL_POT.get(), x, y, z, level);
        this.itemStack = itemStack;
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegistry.EMPTY_OIL_POT.get();
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)this.getDefaultItem());
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void handleEntityEvent(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)this.getDefaultItem());
        if (id == 3) {
            ItemParticleOption itemParticleOption = new ItemParticleOption(ParticleTypes.ITEM, entityStack);
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)itemParticleOption, this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f + (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            Direction direction = result.getDirection();
            BlockPos blockpos = result.getBlockPos();
            ItemOil itemOil = (ItemOil)this.itemStack.getOrDefault(DataComponentsRegistry.OIL, (Object)ItemOil.EMPTY);
            if (itemOil.getOil() == OilsRegistry.ACID_OIL.get()) {
                Vec3i vec3i = result.getDirection().getNormal();
                Vec3 vec3 = Vec3.atLowerCornerOf((Vec3i)vec3i).multiply(0.25, 0.25, 0.25);
                Vec3 vec31 = result.getLocation().add(vec3);
                this.applyAcidSplash(itemOil, vec31, 0.8f);
            } else if (!itemOil.isEmpty()) {
                this.placeOilBlock(blockpos);
                this.placeOilBlock(blockpos.relative(direction.getOpposite()));
                for (BlockPos blockNeighbourPos : Set.of(blockpos.north(), blockpos.east(), blockpos.south(), blockpos.west())) {
                    this.placeOilBlock(blockNeighbourPos);
                }
            }
        }
    }

    protected void placeOilBlock(BlockPos pos) {
        BlockState blockstate = this.level().getBlockState(pos);
        BlockState blockstateUp = this.level().getBlockState(pos.above());
        BlockState blockstateDown = this.level().getBlockState(pos.below());
        BlockState oilblockstate = ((Block)BlockRegistry.OIL_LAYER.get()).defaultBlockState();
        if (blockstateDown.is(BlockRegistry.OIL_LAYER)) {
            return;
        }
        if (blockstateUp.isEmpty() && blockstate.isFaceSturdy((BlockGetter)this.level(), pos, Direction.UP)) {
            this.level().setBlockAndUpdate(pos.above(), oilblockstate);
        } else if (this.level().isEmptyBlock(pos) && blockstateDown.isFaceSturdy((BlockGetter)this.level(), pos.below(), Direction.UP)) {
            this.level().setBlockAndUpdate(pos, oilblockstate);
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            ItemStack itemstack = this.itemStack;
            ItemOil itemOil = (ItemOil)itemstack.getOrDefault(DataComponentsRegistry.OIL, (Object)ItemOil.EMPTY);
            svlevel.playSound(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, SoundEvents.DECORATED_POT_SHATTER, SoundSource.NEUTRAL);
            if (itemOil.getOil() == OilsRegistry.ACID_OIL.get()) {
                svlevel.playSound(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, SoundEvents.LAVA_EXTINGUISH, SoundSource.NEUTRAL);
            }
            if (itemOil.getOil() == OilsRegistry.SMOKE_OIL.get()) {
                svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.SMOKE.get()), result.getLocation().x, result.getLocation().y + 1.0, result.getLocation().z, 3, 0.7, 0.5, 0.7, (double)this.random.nextInt(4) * 0.1);
            } else {
                svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.OIL_SMOKE.get()), result.getLocation().x, result.getLocation().y + 0.5, result.getLocation().z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (!itemOil.isEmpty()) {
                this.applySplash(itemOil, result.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)result).getEntity() : null);
            }
            this.discard();
        }
    }

    private void applySplash(ItemOil itemOil, @Nullable Entity p_entity) {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double dist;
                if (!livingentity.isAffectedByPotions() || !((dist = this.distanceToSqr((Entity)livingentity)) < 16.0)) continue;
                double distMult = livingentity == p_entity ? 1.0 : 1.0 - Math.sqrt(dist) / 4.0;
                if (itemOil.getOil() != OilsRegistry.ACID_OIL.get()) {
                    MobEffectInstance mobeffectInstOil = new MobEffectInstance(MobEffectRegistry.FLAMMABLE, 600, 0);
                    livingentity.addEffect(mobeffectInstOil, this.getEffectSource());
                }
                for (Holder<MobEffect> holder : itemOil.getOil().getEffects()) {
                    MobEffectInstance mobeffectInst = new MobEffectInstance(holder, Mth.floor((double)((double)itemOil.duration() * 1.5)), itemOil.amplifier());
                    if (((MobEffect)holder.value()).isInstantenous()) {
                        ((MobEffect)holder.value()).applyInstantenousEffect((Entity)this, this.getOwner(), livingentity, mobeffectInst.getAmplifier(), distMult);
                        continue;
                    }
                    int i = mobeffectInst.mapDuration(duration -> (int)(distMult * (double)duration + 0.5));
                    MobEffectInstance modifedMobEffectInstance = new MobEffectInstance(holder, i, mobeffectInst.getAmplifier(), mobeffectInst.isAmbient(), mobeffectInst.isVisible());
                    if (modifedMobEffectInstance.endsWithin(20)) continue;
                    livingentity.addEffect(modifedMobEffectInstance, this.getEffectSource());
                }
            }
        }
    }

    public void applyAcidSplash(ItemOil itemOil, Vec3 pos, float radius) {
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 4; ++k) {
                block2: for (int l = 0; l < 4; ++l) {
                    if (j != 0 && j != 3 && k != 0 && k != 3 && l != 0 && l != 3) continue;
                    double d0 = (float)j / 3.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 3.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 3.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = pos.x();
                    double d6 = pos.y();
                    double d8 = pos.z();
                    float f1 = 0.3f;
                    for (float f = radius * (0.7f + this.level().random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)d4, (double)d6, (double)d8);
                        BlockState blockstate = this.level().getBlockState(blockpos);
                        ArrayList<Pair<ItemStack, BlockPos>> dropsList = new ArrayList<Pair<ItemStack, BlockPos>>();
                        if (!this.level().isInWorldBounds(blockpos)) continue block2;
                        Explosion explosion = new Explosion(this.level(), this.getEffectSource(), this.getX(), this.getY(), this.getZ(), radius, false, Explosion.BlockInteraction.KEEP);
                        float resistance = blockstate.getExplosionResistance((BlockGetter)this.level(), blockpos, explosion);
                        if (resistance <= 7.0f) {
                            Player player;
                            Entity entity;
                            this.onAcidHit(itemOil.amplifier(), blockstate, this.level(), blockpos, (entity = this.getEffectSource()) instanceof Player ? (player = (Player)entity) : null, dropsList);
                        }
                        for (Pair pair : dropsList) {
                            Block.popResource((Level)this.level(), (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    protected void onAcidHit(int amplifier, BlockState state, Level level, BlockPos pos, @Nullable Player player, List<Pair<ItemStack, BlockPos>> list) {
        if (state.isAir() || !state.is(Tags.Blocks.ORES) && !state.is(Tags.Blocks.ORE_BEARING_GROUND_STONE) && !state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return;
        }
        if (amplifier < 1 && state.is(BlockTags.NEEDS_IRON_TOOL)) {
            return;
        }
        if (amplifier < 2 && state.is(BlockTags.NEEDS_DIAMOND_TOOL)) {
            return;
        }
        Optional fortune = level.holder(Enchantments.FORTUNE);
        if (fortune.isEmpty()) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)Items.IRON_PICKAXE);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        mutable.set((Holder)fortune.get(), 2);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)mutable.toImmutable());
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            BlockEntity blockentity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
            LootParams.Builder lootParamBuilder = new LootParams.Builder(serverlevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)stack).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockentity).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(player != null ? player.getLuck() : 0.0f);
            state.spawnAfterBreak(serverlevel, pos, ItemStack.EMPTY, player != null);
            state.getDrops(lootParamBuilder).forEach(stack1 -> ThrownOilPot.addOrAppendStack(list, stack1, pos));
        }
        level.destroyBlock(pos, false, this.getEffectSource());
    }

    private static void addOrAppendStack(List<Pair<ItemStack, BlockPos>> drops, ItemStack stack, BlockPos pos) {
        for (int i = 0; i < drops.size(); ++i) {
            Pair<ItemStack, BlockPos> pair = drops.get(i);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.areMergable((ItemStack)itemstack, (ItemStack)stack)) continue;
            drops.set(i, (Pair<ItemStack, BlockPos>)Pair.of((Object)ItemEntity.merge((ItemStack)itemstack, (ItemStack)stack, (int)16), (Object)((BlockPos)pair.getSecond())));
            if (!stack.isEmpty()) continue;
            return;
        }
        drops.add((Pair<ItemStack, BlockPos>)Pair.of((Object)stack, (Object)pos));
    }

    public EntityType<?> getType() {
        return (EntityType)EntityRegistry.OIL_POT.get();
    }
}

