/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.entities.item;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import xyz.yfrostyf.toxony.registries.EntityRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;

public class ToxicCakeProjectile
extends ThrowableItemProjectile {
    public ToxicCakeProjectile(EntityType<? extends ToxicCakeProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ToxicCakeProjectile(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.TOXIC_CAKE_PROJECTILE.get(), shooter, level);
    }

    public ToxicCakeProjectile(Level level, double x, double y, double z) {
        super((EntityType)EntityRegistry.TOXIC_CAKE_PROJECTILE.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return Items.SNOWBALL;
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        return !itemstack.isEmpty() && !itemstack.is(this.getDefaultItem()) ? new ItemParticleOption(ParticleTypes.ITEM, itemstack) : ParticleTypes.ITEM_SLIME;
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffectRegistry.TOXIN, 100, 0), this.getOwner());
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SLIME_BLOCK_PLACE, SoundSource.NEUTRAL, 2.0f, 0.7f);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected double getDefaultGravity() {
        return 0.02;
    }
}

