/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.events.subscribers;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import xyz.yfrostyf.toxony.ToxonyConfig;
import xyz.yfrostyf.toxony.api.registries.ToxonyRegistries;
import xyz.yfrostyf.toxony.items.weapons.WitchingBladeItem;
import xyz.yfrostyf.toxony.registries.AffinityRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

@EventBusSubscriber(modid="toxony", bus=EventBusSubscriber.Bus.MOD)
public class ModifyComponentEvents {
    @SubscribeEvent
    public static void modifyComponents(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)Items.POISONOUS_POTATO, builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), List.of(AffinityRegistry.HEAT.getKey(), AffinityRegistry.FOREST.getKey())));
        event.modify((ItemLike)Items.SPIDER_EYE, builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), List.of(AffinityRegistry.COLD.getKey(), AffinityRegistry.FOREST.getKey())));
        event.modify((ItemLike)Items.WITHER_ROSE, builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), List.of(AffinityRegistry.DECAY.getKey())));
        event.modify((ItemLike)Items.LILY_OF_THE_VALLEY, builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), List.of(AffinityRegistry.FOREST.getKey(), AffinityRegistry.HEAT.getKey())));
        event.modify((ItemLike)Items.RED_MUSHROOM, builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), List.of(AffinityRegistry.FOREST.getKey())));
        event.modify((ItemLike)Items.PUFFERFISH, builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), List.of(AffinityRegistry.OCEAN.getKey())));
        event.modify((ItemLike)Items.ROTTEN_FLESH, builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), List.of(AffinityRegistry.DECAY.getKey())));
        if (!ToxonyConfig.SPEC.isLoaded()) {
            return;
        }
        event.modify((ItemLike)ItemRegistry.WITCHING_BLADE.get(), builder -> builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)WitchingBladeItem.createAttributes(((Double)ToxonyConfig.WITCHINGBLADE_DAMAGE.get()).floatValue() - 1.0f, -2.4f)));
        event.modify((ItemLike)ItemRegistry.FLAIL.get(), builder -> builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)WitchingBladeItem.createAttributes(((Double)ToxonyConfig.FLAIL_DAMAGE.get()).floatValue() - 1.0f, -3.4f + 3.4f * (((Double)ToxonyConfig.FLAIL_SPIN_SPEED_MULT.get()).floatValue() - 1.0f))));
        ModifyComponentEvents.setCustomItemAffinity(event);
    }

    private static void setCustomItemAffinity(ModifyDefaultComponentsEvent event) {
        List configList = (List)ToxonyConfig.CUSTOM_ITEM_AFFINITIES.get();
        Pair itemAffinityPair = new Pair((Object)Items.AIR, new ArrayList());
        for (String s : configList) {
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)s);
            if (resourceLocation == null) continue;
            Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
            Optional optionalAffinity = ToxonyRegistries.AFFINITY_REGISTRY.getHolder(resourceLocation);
            if (item != Items.AIR) {
                if (itemAffinityPair.getFirst() != Items.AIR) {
                    List affinityList = ((List)itemAffinityPair.getSecond()).stream().toList();
                    event.modify((ItemLike)itemAffinityPair.getFirst(), builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), (Object)affinityList));
                }
                itemAffinityPair = new Pair((Object)item, new ArrayList());
                continue;
            }
            if (!optionalAffinity.isPresent()) continue;
            ((List)itemAffinityPair.getSecond()).add(((Holder.Reference)optionalAffinity.get()).key());
        }
        if (itemAffinityPair.getFirst() != Items.AIR) {
            List affinityList = ((List)itemAffinityPair.getSecond()).stream().toList();
            event.modify((ItemLike)itemAffinityPair.getFirst(), builder -> builder.set((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get(), (Object)affinityList));
        }
    }
}

