/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.events.subscribers;

import java.util.Random;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import xyz.yfrostyf.toxony.data.datagen.enchantments.effects.Refill;
import xyz.yfrostyf.toxony.items.PotionFlaskItem;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.ParticleRegistry;

@EventBusSubscriber(modid="toxony")
public class SpecialItemEvents {
    public static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onPlayerAttackBoneSaw(AttackEntityEvent event) {
        LivingEntity targetEntity;
        ItemStack itemInHand = event.getEntity().getMainHandItem();
        Player player = event.getEntity();
        if (!itemInHand.is(ItemRegistry.BONE_SAW) || !(player.getAttackStrengthScale(0.0f) > 0.9f) || RANDOM.nextInt(2) != 0) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && !(targetEntity = (LivingEntity)entity).hasEffect(MobEffectRegistry.CRIPPLE)) {
            targetEntity.addEffect(new MobEffectInstance(MobEffectRegistry.CRIPPLE, 200, 0));
            Entity target = event.getTarget();
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel svlevel = (ServerLevel)level;
                svlevel.playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.TRIDENT_HIT, SoundSource.PLAYERS, 1.0f, 0.7f);
                svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.CUT.get()), target.getX(), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ(), 1, 0.3, 0.2, 0.3, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerSleepWithFlask(PlayerWakeUpEvent event) {
        Level level = event.getEntity().level();
        if (!(level.isClientSide() || event.wakeImmediately() || event.updateLevel())) {
            Inventory inventory = event.getEntity().getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (!(stack.getItem() instanceof PotionFlaskItem)) continue;
                EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                    Refill refill = (Refill)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)DataComponentsRegistry.REFILL.get());
                    if (refill != null) {
                        stack.setDamageValue(SpecialItemEvents.getDamageValueFromRefillEnchant(stack, refill, enchantLevel));
                    }
                });
            }
        }
    }

    private static int getDamageValueFromRefillEnchant(ItemStack stack, Refill refill, int enchantLevel) {
        return Mth.floor((double)((double)stack.getDamageValue() - (double)stack.getMaxDamage() * (0.0 + (double)(refill.value() * (float)enchantLevel))));
    }
}

