/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.events.subscribers.entities;

import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import xyz.yfrostyf.toxony.registries.AttributeRegistry;

@EventBusSubscriber(modid="toxony")
public class ArmorEvents {
    @SubscribeEvent
    public static void onEffectAddedWithEffectReduction(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity livingEntity2 = livingEntity;
            if (!event.getEffectInstance().isInfiniteDuration() && !((MobEffect)event.getEffectInstance().getEffect().value()).isBeneficial()) {
                MobEffectInstance effectInst = event.getEffectInstance();
                int duration = event.getEffectInstance().getDuration();
                for (ItemStack armor : livingEntity2.getArmorSlots()) {
                    Optional<ItemAttributeModifiers.Entry> optional = armor.getAttributeModifiers().modifiers().stream().filter(entry -> entry.attribute().is(AttributeRegistry.EFFECT_REDUCTION.getKey()) && entry.slot().test(livingEntity2.getEquipmentSlotForItem(armor))).findFirst();
                    if (!optional.isPresent()) continue;
                    duration -= Mth.floor((double)optional.get().modifier().amount()) * 20;
                }
                if (duration == event.getEffectInstance().getDuration()) {
                    return;
                }
                effectInst.setDetailsFrom(new MobEffectInstance(effectInst.getEffect(), Math.max(duration, 0), effectInst.getAmplifier()));
            }
        }
    }
}

