/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.events.subscribers.entities.player;

import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.api.events.ChangeToxEvent;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.network.ServerSendMessagePacket;
import xyz.yfrostyf.toxony.network.SyncToxDataPacket;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;

@EventBusSubscriber(modid="toxony")
public class DetoxEvents {
    private static final int GOLDEN_APPLE_DETOX = -30;
    private static final int REGEN_POTION_DETOX = -50;

    @SubscribeEvent
    public static void onRegenPotionDrink(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack item = event.getItem();
        if (!item.has(DataComponents.POTION_CONTENTS) || ((PotionContents)item.get(DataComponents.POTION_CONTENTS)).potion().isEmpty()) {
            return;
        }
        if (((PotionContents)item.get(DataComponents.POTION_CONTENTS)).potion().filter(holder -> holder == Potions.REGENERATION || holder == Potions.LONG_REGENERATION || holder == Potions.STRONG_REGENERATION).isPresent()) {
            ToxData plyToxData = (ToxData)player.getData(DataAttachmentRegistry.TOX_DATA);
            plyToxData.addTox(-50.0f);
            player.setData(DataAttachmentRegistry.TOX_DATA, (Object)plyToxData);
        }
    }

    @SubscribeEvent
    public static void onGoldenAppleEat(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Item item = event.getItem().getItem();
        if (item != Items.GOLDEN_APPLE && item != Items.ENCHANTED_GOLDEN_APPLE) {
            return;
        }
        ToxData plyToxData = (ToxData)player.getData(DataAttachmentRegistry.TOX_DATA);
        plyToxData.addTox(-30.0f);
        player.setData(DataAttachmentRegistry.TOX_DATA, (Object)plyToxData);
    }

    @SubscribeEvent
    public static void onToxBodyReset(ChangeToxEvent event) {
        if (event.getNewTox() > 0.0f || event.isAdding() || event.getToxData().getMutagens().isEmpty()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ToxData toxData = event.getToxData();
        toxData.clearMutagens();
        toxData.clearAffinities();
        entity.setData(DataAttachmentRegistry.TOX_DATA, (Object)toxData);
        entity.playSound(SoundEvents.AMETHYST_BLOCK_BREAK);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            svlevel.sendParticles((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, entity.getX(), entity.getY() + 1.5, entity.getZ(), 15, 0.75, 0.3, 0.75, 0.0);
            if (entity instanceof Player) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)entity), (CustomPacketPayload)SyncToxDataPacket.create(toxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)entity), (CustomPacketPayload)ServerSendMessagePacket.create("message.toxony.tox.mutagen_clear"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

