/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.events.subscribers.entities.player;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.api.mutagens.MutagenData;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.api.util.AffinityUtil;
import xyz.yfrostyf.toxony.items.PotionFlaskItem;
import xyz.yfrostyf.toxony.network.SyncIngredientAffinityMapPacket;
import xyz.yfrostyf.toxony.network.SyncMutagenDataPacket;
import xyz.yfrostyf.toxony.network.SyncToxDataPacket;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;

@EventBusSubscriber(modid="toxony")
public class PlayerEvents {
    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        ToxData plyToxData = (ToxData)event.getEntity().getData((AttachmentType)DataAttachmentRegistry.TOX_DATA.get());
        plyToxData.setPlayer(player);
        player.setData(DataAttachmentRegistry.TOX_DATA, (Object)plyToxData);
        plyToxData.applyMutagens();
        if (!player.level().isClientSide()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)SyncToxDataPacket.create(plyToxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().level().isClientSide()) {
            Player player = event.getEntity();
            ToxData plyToxData = (ToxData)player.getData(DataAttachmentRegistry.TOX_DATA);
            plyToxData.setPlayer(player);
            player.setData(DataAttachmentRegistry.TOX_DATA, (Object)plyToxData);
            plyToxData.applyMutagens();
            if (player instanceof ServerPlayer) {
                ServerPlayer svplayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxDataPacket.create(plyToxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncIngredientAffinityMapPacket.create(AffinityUtil.getIngredientAffinityMap(svplayer.level())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (player.hasData(DataAttachmentRegistry.MUTAGEN_DATA)) {
                    MutagenData mutagenData = (MutagenData)player.getData(DataAttachmentRegistry.MUTAGEN_DATA);
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)SyncMutagenDataPacket.create(mutagenData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (!event.getEntity().level().isClientSide() && event.isWasDeath()) {
            Player player = event.getEntity();
            ToxData oldToxData = (ToxData)event.getOriginal().getData(DataAttachmentRegistry.TOX_DATA);
            oldToxData.setPlayer(player);
            player.setData(DataAttachmentRegistry.TOX_DATA, (Object)oldToxData);
            oldToxData.applyMutagens();
            if (player instanceof ServerPlayer) {
                ServerPlayer svplayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxDataPacket.create(oldToxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncIngredientAffinityMapPacket.create(AffinityUtil.getIngredientAffinityMap(svplayer.level())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (event.getOriginal().hasData(DataAttachmentRegistry.MUTAGEN_DATA)) {
                    MutagenData oldMutagenData = (MutagenData)event.getOriginal().getData(DataAttachmentRegistry.MUTAGEN_DATA);
                    player.setData(DataAttachmentRegistry.MUTAGEN_DATA, (Object)oldMutagenData);
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)SyncMutagenDataPacket.create(oldMutagenData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().level().isClientSide()) {
            Player player = event.getEntity();
            ToxData plyToxData = (ToxData)player.getData(DataAttachmentRegistry.TOX_DATA);
            plyToxData.setPlayer(player);
            player.setData(DataAttachmentRegistry.TOX_DATA, (Object)plyToxData);
            plyToxData.applyMutagens();
            if (player instanceof ServerPlayer) {
                ServerPlayer svplayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxDataPacket.create(plyToxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncIngredientAffinityMapPacket.create(AffinityUtil.getIngredientAffinityMap(svplayer.level())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (player.hasData(DataAttachmentRegistry.MUTAGEN_DATA)) {
                    MutagenData mutagenData = (MutagenData)player.getData(DataAttachmentRegistry.MUTAGEN_DATA);
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)SyncMutagenDataPacket.create(mutagenData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUsePotion(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PotionContents contents = (PotionContents)event.getItem().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            if (contents.potion().isPresent() && contents.potion().get() != Potions.WATER && contents.potion().get() != Potions.AWKWARD && contents.potion().get() != Potions.MUNDANE && contents.potion().get() != Potions.REGENERATION && contents.potion().get() != Potions.STRONG_REGENERATION && contents.potion().get() != Potions.LONG_REGENERATION) {
                ToxData toxData = (ToxData)player.getData((AttachmentType)DataAttachmentRegistry.TOX_DATA.get());
                if (event.getItem().getItem() instanceof PotionFlaskItem) {
                    toxData.addTox(15.0f);
                } else {
                    toxData.addTox(5.0f);
                }
                player.setData(DataAttachmentRegistry.TOX_DATA, (Object)toxData);
            }
        }
    }
}

