/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.events.subscribers.entities.player;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.ToxonyMain;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.api.events.ChangeThresholdEvent;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.client.gui.MutagenTransformOverlay;
import xyz.yfrostyf.toxony.network.SyncToxDataPacket;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.SoundEventRegistry;

@EventBusSubscriber(modid="toxony")
public class ThresholdEvents {
    @SubscribeEvent
    public static void onReachingNewThreshold(ChangeThresholdEvent event) {
        LivingEntity livingEntity;
        if (!event.isAdding() || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = event.getEntity().level();
        if (event.getEntity().level().isClientSide()) {
            MutagenTransformOverlay.startAnimation();
            event.getEntity().playSound((SoundEvent)SoundEventRegistry.MUTAGEN_TRANSFORM.get(), 1.0f, 1.0f);
            return;
        }
        ToxData toxData = event.getToxData();
        ArrayList<Holder<MobEffect>> mobEffects = new ArrayList<Holder<MobEffect>>();
        for (int i = 0; i < event.getNewThreshold() - event.getOldThreshold(); ++i) {
            mobEffects.add(ThresholdEvents.getMutagenFromAffinities(toxData.getAffinities()));
        }
        toxData.clearAffinities();
        toxData.addAndApplyMutagens(mobEffects);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)SyncToxDataPacket.create(toxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static Holder<MobEffect> getMutagenFromAffinities(Map<Affinity, Integer> affinities) {
        HashMap<Holder<MobEffect>, Integer> affinityToValueMap = new HashMap<Holder<MobEffect>, Integer>();
        for (Map.Entry<Affinity, Integer> affinity : affinities.entrySet()) {
            List<Holder<MobEffect>> mutagens = affinity.getKey().getMutagens();
            for (Holder<MobEffect> mutagen : mutagens) {
                if (affinityToValueMap.containsKey(mutagen)) {
                    affinityToValueMap.replace(mutagen, (Integer)affinityToValueMap.get(mutagen) + affinity.getValue());
                    continue;
                }
                affinityToValueMap.put(mutagen, affinity.getValue());
                ToxonyMain.LOGGER.debug("[getMutagenFromAffinities called]: affinityToValueMap: {}", affinityToValueMap);
            }
        }
        Pair largest = null;
        for (Map.Entry entry : affinityToValueMap.entrySet()) {
            ToxonyMain.LOGGER.debug("[getMutagenFromAffinities called]: mob effect pair entry: {}", entry);
            if (largest == null) {
                largest = new Pair((Object)((Holder)entry.getKey()), (Object)((Integer)entry.getValue()));
                continue;
            }
            if ((Integer)entry.getValue() <= (Integer)largest.getSecond()) continue;
            largest = new Pair((Object)((Holder)entry.getKey()), (Object)((Integer)entry.getValue()));
        }
        if (largest == null) {
            return MobEffectRegistry.BEAST_MUTAGEN;
        }
        ToxonyMain.LOGGER.debug("[getMutagenFromAffinities called]: largest pair found: {}", largest);
        return (Holder)largest.getFirst();
    }
}

