/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.events.subscribers.entities.player;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.ToxonyConfig;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.network.SyncToxPacket;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;

@EventBusSubscriber(modid="toxony")
public class ToxTickEvent {
    public static final int TOX_TICK = 80;

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (event.getLevel().getServer().getTickCount() % 80 != 0) {
            return;
        }
        event.getLevel().players().stream().toList().forEach(player -> {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer svplayer = (ServerPlayer)player;
            ToxData plyToxData = (ToxData)svplayer.getData(DataAttachmentRegistry.TOX_DATA);
            if (plyToxData.getTox() > 0.0f && !plyToxData.getDeathState()) {
                plyToxData.addTox(-((Double)ToxonyConfig.TOXIN_DRAIN.get()).floatValue());
                PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxPacket.create(plyToxData.getTox()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }
}

