/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.api.items.ToxGiverItem;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.api.util.AffinityUtil;
import xyz.yfrostyf.toxony.api.util.ToxUtil;
import xyz.yfrostyf.toxony.client.gui.tooltips.StoredAffinityStacksTooltip;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;

public class BlendItem
extends ToxGiverItem {
    private static final Random RANDOM = new Random();

    public BlendItem(Item.Properties properties, float tox, float tolerance, int tier, Supplier<ItemStack> returnItem, List<MobEffectInstance> mobEffectInstances) {
        super(properties, tox, tolerance, tier, returnItem, mobEffectInstances);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ToxData plyToxData = (ToxData)player.getData(DataAttachmentRegistry.TOX_DATA);
        if (stack.has(DataComponentsRegistry.AFFINITY_STORED_ITEMS)) {
            List stored_items = (List)stack.get(DataComponentsRegistry.AFFINITY_STORED_ITEMS);
            for (Holder stored_item : stored_items) {
                ItemStack affinityStack = new ItemStack(stored_item);
                if (!affinityStack.has(DataComponentsRegistry.POSSIBLE_AFFINITIES)) continue;
                AffinityUtil.addAffinityByItem(plyToxData, affinityStack, AffinityUtil.readAffinityFromIngredientMap(affinityStack), Math.max(RANDOM.nextInt(4), 2));
            }
        }
        plyToxData.addTox(this.tox);
        ToxUtil.addToleranceWithTier(player, plyToxData, this.tolerance, this.tier, level);
        this.mobEffectInstances.forEach(mobEffectInstance -> {
            boolean hasEffect = player.hasEffect(mobEffectInstance.getEffect());
            Holder effect = mobEffectInstance.getEffect();
            int effectAmp = mobEffectInstance.getAmplifier();
            int oldEffectDuration = 0;
            int oldEffectAmp = 0;
            if (hasEffect) {
                oldEffectDuration = player.getEffect(mobEffectInstance.getEffect()).getDuration();
                oldEffectAmp = player.getEffect(mobEffectInstance.getEffect()).getAmplifier();
                player.removeEffect(effect);
            }
            if (((MobEffect)mobEffectInstance.getEffect().value()).isInstantenous()) {
                ((MobEffect)mobEffectInstance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, entity, effectAmp, 1.0);
            } else {
                player.addEffect(new MobEffectInstance(effect, mobEffectInstance.getDuration() + oldEffectDuration, Math.max(oldEffectAmp, effectAmp)));
            }
        });
        return ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.BOWL), (boolean)false);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (stack.has(DataComponentsRegistry.AFFINITY_STORED_ITEMS)) {
            return Optional.of(new StoredAffinityStacksTooltip.StoredAffinityStacksTooltipComponent(stack));
        }
        return super.getTooltipImage(stack);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ToxGiverItem.Builder {
        @Override
        public BlendItem build() {
            return new BlendItem(this.properties, this.tox, this.tolerance, this.tier, this.returnItem, this.mobEffectInstances);
        }
    }
}

