/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class BoltCartridgeItem
extends Item {
    public static final int CAPACITY = 3;

    public BoltCartridgeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isCrouching()) {
            ChargedProjectiles projectiles = (ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            if (!projectiles.isEmpty()) {
                stack.remove(DataComponents.CHARGED_PROJECTILES);
                player.getCooldowns().addCooldown((Item)this, 2);
                for (ItemStack projectileStack : projectiles.getItems()) {
                    player.getInventory().add(projectileStack.copyWithCount(stack.getCount()));
                }
                player.playSound((SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), 1.0f, 1.2f);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
            }
            if (projectiles.isEmpty() && BoltCartridgeItem.hasEnoughBolts(3, player)) {
                ItemStack newStack = new ItemStack(ItemRegistry.BOLT_CARTRIDGE, 1);
                newStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(BoltCartridgeItem.getUniqueBolts(3, player)));
                player.getInventory().add(newStack);
                stack.consume(1, (LivingEntity)player);
                player.getCooldowns().addCooldown((Item)this, 2);
                player.playSound((SoundEvent)SoundEvents.CROSSBOW_LOADING_END.value(), 1.0f, 0.8f);
                return InteractionResultHolder.sidedSuccess((Object)(stack.isEmpty() ? ItemStack.EMPTY : stack), (boolean)level.isClientSide());
            }
            if (level.isClientSide()) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.bolt_cartridge.fail"), false);
                return InteractionResultHolder.fail((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public static List<ItemStack> getUniqueBolts(int amount, Player player) {
        LinkedList<ItemStack> uniqueBolts = new LinkedList<ItemStack>();
        ArrayList<Integer> searchedSlots = new ArrayList<Integer>(amount);
        int i = 0;
        for (int j = 0; j < player.getInventory().getContainerSize(); ++j) {
            ItemStack stack = player.getInventory().getItem(j);
            if (i >= amount) break;
            if (!stack.is(TagRegistry.BOLTS)) continue;
            uniqueBolts.add(stack.copyWithCount(1));
            stack.consume(1, (LivingEntity)player);
            searchedSlots.add(j);
            ++i;
        }
        block1: while (player.getInventory().contains(TagRegistry.BOLTS) && i < amount) {
            Iterator iterator = searchedSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                ItemStack stack = player.getInventory().getItem(slot);
                if (i >= amount) continue block1;
                if (!stack.is(TagRegistry.BOLTS)) continue;
                uniqueBolts.add(stack.copyWithCount(1));
                stack.consume(1, (LivingEntity)player);
                ++i;
            }
        }
        return uniqueBolts;
    }

    public static boolean hasEnoughBolts(int amount, Player player) {
        int count = 0;
        List<Item> itemList = BuiltInRegistries.ITEM.getOrCreateTag(TagRegistry.BOLTS).stream().map(Holder::value).toList();
        for (Item item : itemList) {
            if ((count += player.getInventory().countItem(item)) < amount) continue;
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        if (!chargedprojectiles.isEmpty() && BoltCartridgeItem.isLoaded(stack)) {
            MutableComponent component = Component.translatable((String)"item.toxony.cyclebow.loaded").withStyle(ChatFormatting.GRAY);
            tooltipComponents.add((Component)component);
            for (ItemStack itemstack : chargedprojectiles.getItems()) {
                MutableComponent componentItem = Component.literal((String)itemstack.getDisplayName().getString()).withStyle(ChatFormatting.DARK_GRAY);
                tooltipComponents.add((Component)componentItem);
            }
        }
    }

    public String getDescriptionId(ItemStack stack) {
        if (!BoltCartridgeItem.isLoaded(stack)) {
            return this.getDescriptionId() + ".empty";
        }
        return super.getDescriptionId();
    }

    public static boolean isLoaded(ItemStack stack) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        return !chargedprojectiles.isEmpty();
    }
}

