/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class FullVialItem
extends PotionItem {
    private static final int DRINK_DURATION = 16;

    public FullVialItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack getDefaultInstance() {
        ItemStack itemstack = super.getDefaultInstance();
        itemstack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        return itemstack;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (!level.isClientSide) {
            PotionContents potioncontents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            potioncontents.forEachEffect(effect -> {
                if (((MobEffect)effect.getEffect().value()).isInstantenous()) {
                    ((MobEffect)effect.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, entityLiving, effect.getAmplifier(), 1.0);
                } else {
                    entityLiving.addEffect(effect);
                }
            });
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            stack.consume(1, (LivingEntity)player);
        }
        if (player == null || !player.hasInfiniteMaterials()) {
            if (stack.isEmpty()) {
                return new ItemStack(ItemRegistry.GLASS_VIAL);
            }
            if (player != null) {
                player.getInventory().add(new ItemStack(ItemRegistry.GLASS_VIAL));
            }
        }
        entityLiving.gameEvent((Holder)GameEvent.DRINK);
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 16;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }
}

