/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.items.OilPotItem;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class MendingOilPotItem
extends OilPotItem {
    public static final int REPAIR_AMOUNT = 100;

    public MendingOilPotItem(Item.Properties properties, Holder<Block> oilPotBlock) {
        super(properties.stacksTo(1), ItemOil.EMPTY, oilPotBlock);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack otherStack;
        ItemStack oilPot = player.getItemInHand(hand);
        ItemStack itemStack = otherStack = hand == InteractionHand.MAIN_HAND ? player.getOffhandItem() : player.getMainHandItem();
        if (otherStack.is((Item)this)) {
            return InteractionResultHolder.pass((Object)oilPot);
        }
        if (otherStack.is(TagRegistry.CAN_REFILL_OIL)) {
            otherStack.consume(1, (LivingEntity)player);
            oilPot.setDamageValue(0);
        } else {
            if (otherStack.isDamaged() && otherStack.is(TagRegistry.OIL_REPAIRABLE) && oilPot.getDamageValue() < oilPot.getMaxDamage()) {
                return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
            }
            if (!otherStack.is(TagRegistry.OIL_REPAIRABLE) && level.isClientSide()) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.oilpot.mending_fail"), false);
            }
        }
        return InteractionResultHolder.pass((Object)oilPot);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ItemStack applied = player.getMainHandItem().is((Item)this) ? player.getOffhandItem() : player.getMainHandItem();
        int damage = stack.getDamageValue();
        if (!applied.isDamaged() || !applied.is(TagRegistry.OIL_REPAIRABLE)) {
            return stack;
        }
        if (damage < stack.getMaxDamage()) {
            applied.setDamageValue(Math.max(0, applied.getDamageValue() - 100));
            if (stack.isDamageableItem()) {
                stack.setDamageValue(damage + 1);
            }
        }
        return stack;
    }
}

