/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.api.util.OilUtil;
import xyz.yfrostyf.toxony.blocks.OilPotBlock;
import xyz.yfrostyf.toxony.blocks.entities.OilPotBlockEntity;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class OilPotItem
extends Item {
    protected static final int USE_DURATION = 64;
    protected final ItemOil itemOil;
    protected final Holder<Block> oilPotBlock;

    public OilPotItem(Item.Properties properties, ItemOil itemOil, Holder<Block> oilPotBlock) {
        super(properties.stacksTo(1));
        this.itemOil = itemOil;
        this.oilPotBlock = oilPotBlock;
    }

    public ItemOil getItemOil() {
        return this.itemOil;
    }

    public Holder<Block> getOilPotBlock() {
        return this.oilPotBlock;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ItemStack applied = player.getMainHandItem().is((Item)this) ? player.getOffhandItem() : player.getMainHandItem();
        int damage = stack.getDamageValue();
        if (!applied.is(this.getItemOil().getOil().getSupportedItems())) {
            return stack;
        }
        if (this.getItemOil().isEmpty()) {
            return stack;
        }
        if (damage < stack.getMaxDamage()) {
            OilUtil.updateOil(applied, this.getItemOil());
            if (stack.isDamageableItem()) {
                stack.setDamageValue(damage + 1);
            }
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack otherStack;
        ItemStack oilPot = player.getItemInHand(hand);
        ItemStack itemStack = otherStack = hand == InteractionHand.MAIN_HAND ? player.getOffhandItem() : player.getMainHandItem();
        if (otherStack.is(TagRegistry.CAN_REFILL_OIL) && oilPot.getDamageValue() > 0) {
            otherStack.consume(1, (LivingEntity)player);
            oilPot.setDamageValue(0);
        } else if (otherStack.is(this.getItemOil().getOil().getSupportedItems()) && !this.getItemOil().isEmpty() && this.getDamage(oilPot) < this.getMaxDamage(oilPot)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.pass((Object)oilPot);
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result = this.place(new BlockPlaceContext(context));
        if (!result.consumesAction()) {
            result = this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
            return result == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : result;
        }
        return result;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.getPlayer().isCrouching()) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack placingStack = context.getItemInHand();
        BlockState levelBlockState = level.getBlockState(blockpos);
        Block block = (Block)this.getOilPotBlock().value();
        BlockState newBlockState = (BlockState)block.defaultBlockState().setValue((Property)OilPotBlock.OIL_LEFT, (Comparable)Integer.valueOf(OilPotBlock.getBlockDamage(placingStack.getMaxDamage(), placingStack.getDamageValue())));
        if (!(placingStack.getItem() instanceof OilPotItem)) {
            return InteractionResult.FAIL;
        }
        if (!newBlockState.getBlock().isEnabled(context.getLevel().enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(context, block);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(context, blockstate)) {
            return InteractionResult.FAIL;
        }
        context.getLevel().setBlock(blockpos, newBlockState, 11);
        BlockEntity blockEntity = level.getBlockEntity(blockpos);
        if (blockEntity instanceof OilPotBlockEntity) {
            OilPotBlockEntity blockEntity2 = (OilPotBlockEntity)blockEntity;
            blockEntity2.setMaxDamage(placingStack.getMaxDamage());
            blockEntity2.setDamage(placingStack.getDamageValue());
            blockEntity2.setChanged();
        }
        if (levelBlockState.is(newBlockState.getBlock())) {
            levelBlockState = this.updateBlockStateFromTag(blockpos, level, placingStack, levelBlockState);
            OilPotItem.updateCustomBlockEntityTag(level, player, blockpos, placingStack);
            OilPotItem.updateBlockEntityComponents(level, blockpos, placingStack);
            levelBlockState.getBlock().setPlacedBy(level, blockpos, levelBlockState, (LivingEntity)player, placingStack);
        }
        SoundType soundtype = levelBlockState.getSoundType((LevelReader)level, blockpos, (Entity)context.getPlayer());
        level.playSound(player, blockpos, SoundEvents.DECORATED_POT_PLACE, SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)levelBlockState));
        placingStack.consume(1, (LivingEntity)player);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected BlockState getPlacementState(BlockPlaceContext context, Block block) {
        BlockState blockstate = block.getStateForPlacement(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.getPlayer();
        CollisionContext collisioncontext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) && context.getLevel().isUnobstructed(state, context.getClickedPos(), collisioncontext);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 11);
    }

    private static void updateBlockEntityComponents(Level level, BlockPos poa, ItemStack stack) {
        BlockEntity blockentity = level.getBlockEntity(poa);
        if (blockentity != null) {
            blockentity.applyComponentsFromItemStack(stack);
            blockentity.setChanged();
        }
    }

    public static boolean updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        BlockEntity blockentity;
        MinecraftServer minecraftserver = level.getServer();
        if (minecraftserver == null) {
            return false;
        }
        CustomData customdata = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!customdata.isEmpty() && (blockentity = level.getBlockEntity(pos)) != null) {
            if (level.isClientSide || !blockentity.onlyOpCanSetNbt() || player != null && player.canUseGameMasterBlocks()) {
                return customdata.loadInto(blockentity, (HolderLookup.Provider)level.registryAccess());
            }
            return false;
        }
        return false;
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockItemStateProperties blockitemstateproperties = (BlockItemStateProperties)stack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
        if (blockitemstateproperties.isEmpty()) {
            return state;
        }
        BlockState blockstate = blockitemstateproperties.apply(state);
        if (blockstate != state) {
            level.setBlock(pos, blockstate, 2);
        }
        return blockstate;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 64;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_BLOCK_PLACE;
    }
}

