/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import xyz.yfrostyf.toxony.registries.BlockRegistry;

public class PoisonPasteItem
extends Item {
    public PoisonPasteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Pair pair;
        Level level = context.getLevel();
        Pair pair2 = pair = !(level.getBlockState(blockpos = context.getClickedPos()).getBlock() instanceof FarmBlock) ? null : Pair.of(ctx -> true, PoisonPasteItem.changeIntoState(((Block)BlockRegistry.POISON_FARMLAND.get()).defaultBlockState()));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.getPlayer();
            level.playSound(player, blockpos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                consumer.accept(context);
                if (player != null) {
                    context.getItemInHand().consume(1, (LivingEntity)player);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static Consumer<UseOnContext> changeIntoState(BlockState state) {
        return context -> {
            context.getLevel().setBlock(context.getClickedPos(), state, 11);
            context.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, context.getClickedPos(), GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)state));
        };
    }
}

