/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class PotionFlaskItem
extends Item {
    private static final int DRINK_DURATION = 48;
    private final float durationModifier;

    public PotionFlaskItem(Item.Properties properties, float durationModifier) {
        super(properties);
        this.durationModifier = durationModifier;
    }

    public ItemStack getDefaultInstance() {
        ItemStack itemstack = super.getDefaultInstance();
        itemstack.set(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return itemstack;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (!level.isClientSide) {
            PotionContents potioncontents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            potioncontents.forEachEffect(effect -> {
                if (((MobEffect)effect.getEffect().value()).isInstantenous()) {
                    ((MobEffect)effect.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, entityLiving, effect.getAmplifier(), 1.0);
                } else {
                    entityLiving.addEffect(new MobEffectInstance(effect.getEffect(), Mth.floor((float)((float)effect.getDuration() * this.durationModifier)), effect.getAmplifier(), effect.isAmbient(), effect.isVisible(), effect.showIcon()));
                }
            });
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (player == null || !player.hasInfiniteMaterials()) {
            this.setDamage(stack, this.getDamage(stack) + 1);
        }
        entityLiving.gameEvent((Holder)GameEvent.DRINK);
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 48;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack otherStack = player.getMainHandItem().is((Item)this) ? player.getOffhandItem() : player.getMainHandItem();
        ItemStack thisStack = player.getItemInHand(hand);
        if (!PotionFlaskItem.hasActualPotion(thisStack)) {
            if (!otherStack.is((Item)this) && PotionFlaskItem.hasActualPotion(otherStack)) {
                if (otherStack.is(ItemRegistry.TOX_VIAL)) {
                    player.getInventory().add(new ItemStack(ItemRegistry.GLASS_VIAL));
                } else if (otherStack.is(Items.POTION)) {
                    player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                }
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                thisStack.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)otherStack.get(DataComponents.POTION_CONTENTS)));
                otherStack.consume(1, (LivingEntity)player);
                this.setDamage(thisStack, 0);
                return InteractionResultHolder.consume((Object)thisStack);
            }
        } else {
            if (otherStack.is(ItemRegistry.TOXIC_FORMULA) && thisStack.getDamageValue() > 0) {
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                thisStack.setDamageValue(0);
                otherStack.consume(1, (LivingEntity)player);
                player.getInventory().add(new ItemStack(ItemRegistry.GLASS_VIAL, 1));
                return InteractionResultHolder.consume((Object)thisStack);
            }
            if (thisStack.getDamageValue() < thisStack.getMaxDamage()) {
                return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
            }
        }
        return InteractionResultHolder.pass((Object)thisStack);
    }

    private static boolean hasActualPotion(ItemStack stack) {
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return contents.potion().isPresent() && contents != PotionContents.EMPTY && contents.potion().get() != Potions.AWKWARD && contents.potion().get() != Potions.MUNDANE && contents.potion().get() != Potions.WATER;
    }

    public static float isFull(ItemStack stack) {
        if (!PotionFlaskItem.hasActualPotion(stack) || stack.getDamageValue() >= stack.getMaxDamage()) {
            return 0.0f;
        }
        if (stack.isDamaged()) {
            return 0.5f;
        }
        return 1.0f;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 14;
    }

    public String getDescriptionId(ItemStack stack) {
        return Potion.getName((Optional)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion(), (String)(this.getDescriptionId() + ".effect."));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        PotionContents potioncontents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potioncontents != null) {
            potioncontents.addPotionTooltip(tooltipComponents::add, this.durationModifier, context.tickRate());
        }
    }
}

