/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.ToxonyConfig;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.api.util.ToxUtil;
import xyz.yfrostyf.toxony.api.util.VialUtil;
import xyz.yfrostyf.toxony.damages.NeedleDamageSource;
import xyz.yfrostyf.toxony.network.SyncToxDataPacket;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.PotionRegistry;

public class ToxNeedleItem
extends Item {
    private final float HEALTH_THRESHOLD_PERCENT = 0.1f;

    public ToxNeedleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack otherStack;
        ItemStack thisStack = player.getItemInHand(hand);
        ItemStack itemStack = otherStack = hand == InteractionHand.MAIN_HAND ? player.getOffhandItem() : player.getMainHandItem();
        if (thisStack.has(DataComponentsRegistry.AFFINITY_STORED_ITEM) || thisStack.has(DataComponents.POTION_CONTENTS)) {
            if (player.isCrouching()) {
                player.playSound(SoundEvents.GENERIC_BURN, 0.8f, 0.5f);
                return InteractionResultHolder.sidedSuccess((Object)new ItemStack((ItemLike)ItemRegistry.COPPER_NEEDLE.get()), (boolean)level.isClientSide());
            }
            if (otherStack.is(ItemRegistry.GLASS_VIAL)) {
                if (thisStack.has(DataComponentsRegistry.AFFINITY_STORED_ITEM)) {
                    Holder holder = (Holder)thisStack.get(DataComponentsRegistry.AFFINITY_STORED_ITEM);
                    ItemStack affinityStack = new ItemStack((ItemLike)ItemRegistry.AFFINITY_SOLUTION.get());
                    affinityStack.set(DataComponentsRegistry.AFFINITY_STORED_ITEM, (Object)holder);
                    player.getInventory().add(affinityStack);
                } else if (thisStack.has(DataComponents.POTION_CONTENTS)) {
                    PotionContents potionContents = (PotionContents)thisStack.get(DataComponents.POTION_CONTENTS);
                    if (potionContents.is(PotionRegistry.TOXIN)) {
                        player.getInventory().add(new ItemStack(ItemRegistry.TOXIN, 1));
                    } else {
                        player.getInventory().add(VialUtil.createPotionItemStack((Item)ItemRegistry.TOX_VIAL.get(), (Holder<Potion>)((Holder)potionContents.potion().get())));
                    }
                }
                otherStack.consume(1, (LivingEntity)player);
                player.playSound(SoundEvents.BOTTLE_FILL, 1.0f, 0.5f);
                return InteractionResultHolder.sidedSuccess((Object)new ItemStack((ItemLike)ItemRegistry.COPPER_NEEDLE.get()), (boolean)level.isClientSide());
            }
        }
        return InteractionResultHolder.pass((Object)thisStack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity targetEntity, InteractionHand thisHand) {
        float targetHealth = targetEntity.getHealth();
        float targetMaxHealth = targetEntity.getMaxHealth();
        Level level = player.level();
        ToxData plyToxData = (ToxData)player.getData((AttachmentType)DataAttachmentRegistry.TOX_DATA.get());
        if (targetHealth <= 0.0f || !targetEntity.isAlive()) {
            return InteractionResult.PASS;
        }
        if (stack.has(DataComponentsRegistry.AFFINITY_STORED_ITEM)) {
            if (targetHealth > targetMaxHealth * 0.1f) {
                if (player.level().isClientSide()) {
                    Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.needle.fail"), false);
                }
                return InteractionResult.FAIL;
            }
            ToxNeedleItem.handleKnowledgeFromItem((LivingEntity)player, plyToxData, stack);
            targetEntity.hurt((DamageSource)new NeedleDamageSource((Holder<DamageType>)player.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(DamageTypes.PLAYER_ATTACK), (Entity)player), 5.0f);
            player.playSound(SoundEvents.BEE_STING, 1.0f, 0.5f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.hasInfiniteMaterials()) {
                player.setItemInHand(thisHand, new ItemStack(ItemRegistry.COPPER_NEEDLE));
            }
            return InteractionResult.sidedSuccess((boolean)targetEntity.level().isClientSide());
        }
        if (stack.has(DataComponents.POTION_CONTENTS)) {
            PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (potionContents.hasEffects() && !level.isClientSide()) {
                potionContents.forEachEffect(effect -> {
                    ToxNeedleItem.handleToxin(targetEntity, (Holder<MobEffect>)effect.getEffect());
                    if (((MobEffect)effect.getEffect().value()).isInstantenous()) {
                        ((MobEffect)effect.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, targetEntity, effect.getAmplifier(), 1.0);
                    } else {
                        targetEntity.addEffect(effect);
                    }
                });
            }
            targetEntity.hurt((DamageSource)new NeedleDamageSource((Holder<DamageType>)player.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(DamageTypes.PLAYER_ATTACK), (Entity)player), 2.0f);
            player.playSound(SoundEvents.BEE_STING, 1.0f, 0.5f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown((Item)this, 60);
            if (!player.hasInfiniteMaterials()) {
                player.setItemInHand(thisHand, new ItemStack(ItemRegistry.COPPER_NEEDLE));
            }
            return InteractionResult.sidedSuccess((boolean)targetEntity.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    private static void handleKnowledgeFromItem(LivingEntity entity, ToxData toxData, ItemStack stack) {
        ItemStack storedStack = new ItemStack((ItemLike)((Holder)stack.get(DataComponentsRegistry.AFFINITY_STORED_ITEM)).value());
        toxData.addKnownIngredients(storedStack, 10);
        if (toxData.getIngredientProgress(storedStack) >= (Integer)ToxonyConfig.MIN_KNOWLEDGE_REQ.get()) {
            if (entity.level().isClientSide()) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.needle.knowledge.success", (Object[])new Object[]{Component.translatable((String)storedStack.getDescriptionId()).getString()}), false);
            }
        } else if (entity.level().isClientSide()) {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.needle.knowledge.fail", (Object[])new Object[]{Component.translatable((String)storedStack.getDescriptionId()).getString()}), false);
        }
    }

    public static void handleToxin(LivingEntity targetEntity, Holder<MobEffect> effect) {
        if (targetEntity instanceof ServerPlayer) {
            ServerPlayer svplayer = (ServerPlayer)targetEntity;
            ToxData toxData = (ToxData)svplayer.getData(DataAttachmentRegistry.TOX_DATA);
            Float toxinAmt = Float.valueOf(toxData.getTox());
            if (effect.is(MobEffects.REGENERATION) || effect.is(MobEffects.HEAL)) {
                toxinAmt = Float.valueOf(toxinAmt.floatValue() + -8.0f);
            }
            if (effect.is(MobEffectRegistry.TOXIN) || effect.is(MobEffects.POISON)) {
                boolean isToxin = effect.is(MobEffectRegistry.TOXIN);
                toxinAmt = Float.valueOf(toxinAmt.floatValue() + (isToxin ? 30.0f : 10.0f));
            }
            toxData.addTox(toxinAmt.floatValue());
            svplayer.setData(DataAttachmentRegistry.TOX_DATA, (Object)toxData);
            PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxDataPacket.create(toxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            float maxHealth = targetEntity.getMaxHealth();
            Float toxinAmt = targetEntity.hasData(DataAttachmentRegistry.MOB_TOXIN) ? (Float)targetEntity.getData(DataAttachmentRegistry.MOB_TOXIN) : Float.valueOf(0.0f);
            float maxHealthMult = (float)Math.clamp((Math.sqrt(maxHealth) - 2.0) * 0.05, 0.0, 2.0);
            if (effect.is(MobEffects.REGENERATION) || effect.is(MobEffects.HEAL)) {
                toxinAmt = Float.valueOf(toxinAmt.floatValue() + -8.0f * maxHealthMult);
            } else if (effect.is(MobEffectRegistry.TOXIN) || effect.is(MobEffects.POISON)) {
                boolean isToxin = effect.is(MobEffectRegistry.TOXIN);
                toxinAmt = Float.valueOf(toxinAmt.floatValue() + (isToxin ? 30.0f * maxHealthMult : 10.0f * maxHealthMult));
            }
            ToxUtil.setMobToxin(targetEntity, toxinAmt.floatValue());
        }
    }

    public String getDescriptionId(ItemStack stack) {
        if (stack.has(DataComponents.POTION_CONTENTS)) {
            return Potion.getName((Optional)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion(), (String)(this.getDescriptionId() + ".effect."));
        }
        if (stack.has(DataComponentsRegistry.AFFINITY_STORED_ITEM)) {
            return this.getDescriptionId() + ".affinity";
        }
        return super.getDescriptionId();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        PotionContents potioncontents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potioncontents != null) {
            potioncontents.addPotionTooltip(tooltipComponents::add, 1.0f, context.tickRate());
        }
    }
}

