/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Blocks;
import xyz.yfrostyf.toxony.api.items.ToxFueledItem;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;

public class ToxScalpelItem
extends ToxFueledItem {
    public ToxScalpelItem(Item.Properties properties, int tickrate, int cooldown, SoundEvent sound) {
        super(properties.component(DataComponents.TOOL, (Object)ToxScalpelItem.createToolProperties()), tickrate, cooldown, sound);
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)), 1.0f, 2);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (ToxScalpelItem.isActive(stack)) {
            target.addEffect(new MobEffectInstance(MobEffectRegistry.TOXIN, 120, 0));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ToxFueledItem.Builder {
        @Override
        public ToxScalpelItem build() {
            return new ToxScalpelItem(this.properties, this.tickrate, this.cooldown, this.sound);
        }
    }
}

