/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items.armor;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import xyz.yfrostyf.toxony.registries.AttributeRegistry;

public class PlaguebringerArmorItem
extends ArmorItem {
    public PlaguebringerArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        int defense = ((ArmorMaterial)this.material.value()).getDefense(this.type);
        float toughness = ((ArmorMaterial)this.material.value()).toughness();
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot());
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("armor." + this.type.getName()));
        ResourceLocation resourcelocationtoxony = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)("armor." + this.type.getName()));
        builder.add(Attributes.ARMOR, new AttributeModifier(resourcelocation, (double)defense, AttributeModifier.Operation.ADD_VALUE), equipslotgroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourcelocation, (double)toughness, AttributeModifier.Operation.ADD_VALUE), equipslotgroup);
        float f1 = ((ArmorMaterial)this.material.value()).knockbackResistance();
        if (f1 > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourcelocation, (double)f1, AttributeModifier.Operation.ADD_VALUE), equipslotgroup);
        }
        builder.add(AttributeRegistry.EFFECT_REDUCTION, new AttributeModifier(resourcelocationtoxony, this.getEffectDurationValue(equipslotgroup), AttributeModifier.Operation.ADD_VALUE), equipslotgroup);
        return builder.build();
    }

    protected double getEffectDurationValue(EquipmentSlotGroup equipSlot) {
        return switch (equipSlot) {
            case EquipmentSlotGroup.HEAD -> 5.0;
            case EquipmentSlotGroup.CHEST -> 3.0;
            case EquipmentSlotGroup.LEGS -> 2.0;
            case EquipmentSlotGroup.FEET -> 1.0;
            default -> 0.0;
        };
    }
}

