/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items.weapons;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import xyz.yfrostyf.toxony.items.BoltItem;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class CycleBowItem
extends ProjectileWeaponItem {
    public static final Predicate<ItemStack> ARROWS_BOLTS_CARTRIDGES = ((Predicate<ItemStack>)itemstack -> itemstack.is(TagRegistry.BOLTS)).or(itemstack -> itemstack.is(ItemTags.ARROWS)).or(itemstack -> itemstack.is(ItemRegistry.BOLT_CARTRIDGE) && itemstack.has(DataComponents.CHARGED_PROJECTILES));
    private static final float ARROW_POWER = 3.4f;
    private static final float DEFAULT_SINGLE_LOAD = 20.0f;
    private final int maxShots;

    public CycleBowItem(Item.Properties properties, int maxShots) {
        super(properties);
        this.maxShots = maxShots;
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles(ItemStack stack) {
        return ARROWS_BOLTS_CARTRIDGES;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROWS_BOLTS_CARTRIDGES;
    }

    public void performShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, float velocity, float inaccuracy, @Nullable LivingEntity target) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            weapon.set(DataComponentsRegistry.LOADED_SHOTS, (Object)((Integer)weapon.getOrDefault(DataComponentsRegistry.LOADED_SHOTS, (Object)0) - 1));
            ChargedProjectiles chargedprojectiles = (ChargedProjectiles)weapon.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            if (!chargedprojectiles.isEmpty()) {
                ArrayList chargedprojectilesStacks = new ArrayList(chargedprojectiles.getItems());
                this.shoot(serverlevel, shooter, hand, weapon, List.of((ItemStack)chargedprojectilesStacks.removeFirst()), velocity, inaccuracy, shooter instanceof Player, target);
                if (shooter instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)shooter;
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)weapon.getItem()));
                }
                weapon.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(chargedprojectilesStacks));
            }
            if (!CycleBowItem.isLoaded(weapon)) {
                weapon.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            }
        }
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        AbstractArrow abstractarrow;
        ArrowItem arrowItemDefault = (ArrowItem)Items.ARROW;
        Item item = ammo.getItem();
        if (item instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            abstractarrow = arrowItem.createArrow(level, ammo, shooter, weapon);
        } else {
            item = ammo.getItem();
            if (item instanceof BoltItem) {
                BoltItem boltItem = (BoltItem)item;
                abstractarrow = boltItem.createBolt(level, ammo, shooter, weapon);
            } else {
                abstractarrow = arrowItemDefault.createArrow(level, ammo, shooter, weapon);
            }
        }
        if (isCrit) {
            abstractarrow.setCritArrow(true);
        }
        return abstractarrow;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vec3 vec3 = shooter.getUpVector(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
        Vec3 vec31 = shooter.getViewVector(1.0f);
        Vector3f vector3f = vec31.toVector3f().rotate((Quaternionfc)quaternionf);
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
        float f = CycleBowItem.getShotPitch(shooter.getRandom(), index);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.CROSSBOW_SHOOT, shooter.getSoundSource(), 1.0f, f);
    }

    private static float getShotPitch(RandomSource random, int index) {
        return index == 0 ? 1.0f : CycleBowItem.getRandomShotPitch((index & 1) == 1, random);
    }

    private static float getRandomShotPitch(boolean isHighPitched, RandomSource random) {
        float f = isHighPitched ? 0.83f : 0.63f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    public int getDefaultProjectileRange() {
        return 6;
    }

    private boolean tryLoadProjectiles(LivingEntity shooter, ItemStack stack, ItemStack ammo) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>(((ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY)).getItems());
        int loadedShots = (Integer)stack.getOrDefault(DataComponentsRegistry.LOADED_SHOTS, (Object)0);
        if (loadedShots <= this.maxShots && !ammo.isEmpty()) {
            if (ammo.is(ItemRegistry.BOLT_CARTRIDGE)) {
                if (ammo.has(DataComponents.CHARGED_PROJECTILES) && CycleBowItem.getLoadedShots(stack) == 0) {
                    ItemStack usedAmmo = CycleBowItem.useAmmo((ItemStack)stack, (ItemStack)ammo, (LivingEntity)shooter, (boolean)false);
                    stack.set(DataComponents.CHARGED_PROJECTILES, (Object)((ChargedProjectiles)usedAmmo.get(DataComponents.CHARGED_PROJECTILES)));
                    if (shooter instanceof Player) {
                        Player player = (Player)shooter;
                        usedAmmo.remove(DataComponents.CHARGED_PROJECTILES);
                        player.getInventory().add(usedAmmo.copy());
                    }
                    stack.set(DataComponentsRegistry.LOADED_SHOTS, (Object)3);
                    return true;
                }
                return false;
            }
            ItemStack usedAmmo = CycleBowItem.useAmmo((ItemStack)stack, (ItemStack)ammo, (LivingEntity)shooter, (boolean)false);
            list.add(usedAmmo);
            stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(list));
            stack.set(DataComponentsRegistry.LOADED_SHOTS, (Object)(loadedShots + 1));
            return true;
        }
        return false;
    }

    public static int getLoadedShots(ItemStack crossbowStack) {
        return (Integer)crossbowStack.getOrDefault(DataComponentsRegistry.LOADED_SHOTS, (Object)0);
    }

    public static boolean isLoaded(ItemStack crossbowStack) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)crossbowStack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        Integer loadedShots = (Integer)crossbowStack.getOrDefault(DataComponentsRegistry.LOADED_SHOTS, (Object)0);
        return !chargedprojectiles.isEmpty() && loadedShots > 0;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.getProjectile(itemstack).isEmpty() && !player.hasInfiniteMaterials() && !CycleBowItem.isLoaded(itemstack)) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (CycleBowItem.isLoaded(itemstack)) {
            this.performShooting(level, (LivingEntity)player, hand, itemstack, 3.4f, 1.0f, null);
            itemstack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            player.getCooldowns().addCooldown((Item)this, 10);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remaining) {
        Item item;
        if (!level.isClientSide && (item = stack.getItem()) instanceof CycleBowItem) {
            CycleBowItem cycleBowItem = (CycleBowItem)item;
            int tickThreshold = Mth.floor((float)(((float)cycleBowItem.getUseDuration(stack, livingEntity) - 20.0f) / (float)this.maxShots));
            int useDuration = this.getUseDuration(stack, livingEntity);
            ItemStack ammoStack = livingEntity.getProjectile(stack);
            if (remaining == useDuration) {
                level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.CROSSBOW_LOADING_START, livingEntity.getSoundSource(), 1.0f, 1.0f);
            } else if (ammoStack.is(ItemRegistry.BOLT_CARTRIDGE) && CycleBowItem.getLoadedShots(stack) == 0) {
                if ((float)remaining == 30.0f && this.tryLoadProjectiles(livingEntity, stack, ammoStack)) {
                    level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.CROSSBOW_LOADING_MIDDLE, livingEntity.getSoundSource(), 1.0f, 0.8f);
                }
            } else if (remaining % tickThreshold == 0 && remaining <= useDuration - tickThreshold && CycleBowItem.getLoadedShots(stack) < this.maxShots && this.tryLoadProjectiles(livingEntity, stack, ammoStack)) {
                level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.CROSSBOW_LOADING_MIDDLE, livingEntity.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (CycleBowItem.isLoaded(stack)) {
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.CROSSBOW_LOADING_END, livingEntity.getSoundSource(), 0.5f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return (int)((float)this.maxShots * 20.0f + 20.0f);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public boolean useOnRelease(ItemStack stack) {
        return stack.is((Item)this);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 18;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(Items.COPPER_INGOT);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedprojectiles != null && CycleBowItem.isLoaded(stack)) {
            MutableComponent component = Component.translatable((String)"item.toxony.cyclebow.loaded").withStyle(ChatFormatting.GRAY);
            tooltipComponents.add((Component)component);
            for (ItemStack itemstack : chargedprojectiles.getItems()) {
                MutableComponent componentItem = Component.literal((String)itemstack.getDisplayName().getString()).withStyle(ChatFormatting.DARK_GRAY);
                tooltipComponents.add((Component)componentItem);
            }
        }
    }
}

