/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items.weapons;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.api.util.OilUtil;
import xyz.yfrostyf.toxony.entities.item.FlailBall;
import xyz.yfrostyf.toxony.items.OilPotItem;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;

public class FlailItem
extends Item {
    private static final int DEFAULT_USE_DURATION = 80;

    public FlailItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && !(player.getOffhandItem().getItem() instanceof OilPotItem)) {
            player.startUsingItem(hand);
            player.resetAttackStrengthTicker();
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        Player player;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getOffhandItem().is((Item)this) && player.isUsingItem()) {
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int chargeRemaining) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.NEUTRAL, 0.8f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide()) {
                int useDuration = this.getUseDuration(stack, (LivingEntity)player);
                float newChargeRemaining = Math.max(chargeRemaining, 0);
                float chargeProgress = (float)(1.0 - (double)(newChargeRemaining / (float)useDuration));
                double playerDamage = player.getAttribute(Attributes.ATTACK_DAMAGE) != null ? player.getAttribute(Attributes.ATTACK_DAMAGE).getValue() * (double)chargeProgress : 1.0;
                ItemOil itemOil = null;
                if (stack.has(DataComponentsRegistry.OIL)) {
                    itemOil = (ItemOil)stack.get(DataComponentsRegistry.OIL);
                    OilUtil.useOil(level, stack, 1);
                }
                level.addFreshEntity((Entity)new FlailBall(player, level, stack, Mth.floor((float)(4.0f * chargeProgress)), (float)playerDamage, chargeRemaining <= 0, 0.25f + FlailItem.getImpactBasedOnEnchant(stack), itemOil));
            }
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            player.getCooldowns().addCooldown((Item)this, 20);
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
    }

    private static float getImpactBasedOnEnchant(ItemStack stack) {
        AtomicInteger atomicValue = new AtomicInteger(0);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
            if (((Enchantment)enchantmentHolder.value()).effects().has((DataComponentType)DataComponentsRegistry.IMPACT.get())) {
                atomicValue.set(enchantLevel);
            }
        });
        return (float)atomicValue.get() * 0.25f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFlailThrown(LivingEntity livingEntity) {
        if (!(livingEntity instanceof Player)) return false;
        Player player = (Player)livingEntity;
        Item item = player.getMainHandItem().getItem();
        if (!(item instanceof FlailItem)) return false;
        FlailItem item2 = (FlailItem)item;
        if (!player.getCooldowns().isOnCooldown((Item)item2)) return false;
        return true;
    }

    public static boolean isUsingFlail(LivingEntity livingEntity) {
        Player player;
        return livingEntity instanceof Player && (player = (Player)livingEntity).getMainHandItem().getItem() instanceof FlailItem && player.isUsingItem();
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        ItemStack stack = damageSource.getWeaponItem();
        if (stack != null && stack.is((Item)this)) {
            Optional<ItemAttributeModifiers.Entry> optional = stack.getAttributeModifiers().modifiers().stream().filter(e -> e.modifier().is(BASE_ATTACK_DAMAGE_ID)).findFirst();
            return optional.isPresent() ? (float)(-optional.get().modifier().amount()) : 0.0f;
        }
        return super.getAttackDamageBonus(target, damage, damageSource);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        if (entity.getAttribute(Attributes.ATTACK_SPEED) != null) {
            return Mth.floor((double)(20.0 / entity.getAttribute(Attributes.ATTACK_SPEED).getValue()));
        }
        return 80;
    }

    public boolean useOnRelease(ItemStack stack) {
        return stack.is((Item)this);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 14;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(Items.IRON_INGOT);
    }
}

