/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items.weapons;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import xyz.yfrostyf.toxony.entities.item.FlintlockBall;
import xyz.yfrostyf.toxony.items.FlintlockRoundItem;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.ParticleRegistry;
import xyz.yfrostyf.toxony.registries.SoundEventRegistry;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class FlintlockItem
extends ProjectileWeaponItem {
    public static final Predicate<ItemStack> ROUNDS = itemstack -> itemstack.is(TagRegistry.ROUNDS);
    private static final float ROUND_POWER = 3.6f;

    public FlintlockItem(Item.Properties properties) {
        super(properties);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles(ItemStack stack) {
        return ROUNDS;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ROUNDS;
    }

    public void performShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, float velocity, float inaccuracy, @Nullable LivingEntity target) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (!(shooter instanceof Player)) {
                return;
            }
            ChargedProjectiles chargedprojectiles = (ChargedProjectiles)weapon.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            if (!chargedprojectiles.isEmpty()) {
                this.shoot(serverlevel, shooter, hand, weapon, chargedprojectiles.getItems(), velocity, inaccuracy, shooter instanceof Player, target);
                if (shooter instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)shooter;
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)weapon.getItem()));
                }
                weapon.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
            }
        }
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        Item item;
        if (!ammo.isEmpty() && (item = ammo.getItem()) instanceof FlintlockRoundItem) {
            FlintlockRoundItem round = (FlintlockRoundItem)item;
            return round.asProjectile(level, (Position)shooter.position(), weapon, Direction.UP);
        }
        FlintlockBall roundEntity = new FlintlockBall(level, ammo, 9.0f, 0);
        return roundEntity;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vec3 vec3 = shooter.getUpVector(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
        Vec3 vec31 = shooter.getViewVector(1.0f);
        Vector3f vector3f = vec31.toVector3f().rotate((Quaternionfc)quaternionf);
        if (projectile instanceof FlintlockBall) {
            FlintlockBall roundEntity = (FlintlockBall)projectile;
            roundEntity.shoot(shooter, vector3f.x, vector3f.y, vector3f.z, velocity, inaccuracy);
        }
        ItemStack mainstack = shooter.getMainHandItem();
        ItemStack offstack = shooter.getOffhandItem();
        ItemStack usingstack = shooter.getUseItem();
        Quaternionf quaternionfoffset = quaternionf;
        float rotationOffset = 11.0f;
        if (mainstack.is(ItemRegistry.FLINTLOCK) && (ItemStack.matches((ItemStack)offstack, (ItemStack)usingstack) || !offstack.is(ItemRegistry.FLINTLOCK))) {
            quaternionfoffset = new Quaternionf().setAngleAxis((double)((angle - 11.0f) * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
        }
        if (offstack.is(ItemRegistry.FLINTLOCK) && (ItemStack.matches((ItemStack)mainstack, (ItemStack)usingstack) || !mainstack.is(ItemRegistry.FLINTLOCK))) {
            quaternionfoffset = new Quaternionf().setAngleAxis((double)((angle + 11.0f) * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
        }
        Vector3f vector3foffset = vec31.toVector3f().rotate((Quaternionfc)quaternionfoffset);
        Vector3f vector3fScaled = vector3foffset.mul(1.5f);
        ServerLevel svlevel = (ServerLevel)shooter.level();
        svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLINTLOCK_BLAST_LARGE.get()), shooter.getX() + (double)vector3fScaled.x, shooter.getEyeY() - (double)0.3f + (double)vector3fScaled.y, shooter.getZ() + (double)vector3fScaled.z, 1, 0.0, 0.0, 0.0, 0.0);
        svlevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, shooter.getX() + (double)vector3fScaled.x, shooter.getEyeY() - (double)0.3f + (double)vector3fScaled.y, shooter.getZ() + (double)vector3fScaled.z, 4, 0.0, 0.0, 0.0, 0.0);
        float pitch = FlintlockItem.getShotPitch(shooter.getRandom(), index);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEventRegistry.FLINTLOCK_SHOOT, shooter.getSoundSource(), 1.0f, pitch);
    }

    private static float getShotPitch(RandomSource random, int index) {
        float highPitchFactor = (index & 1) == 1 ? 0.83f : 0.63f;
        float value = 1.0f / (random.nextFloat() * 0.5f + 1.8f) + highPitchFactor;
        return index == 0 ? 1.0f : value;
    }

    public int getDefaultProjectileRange() {
        return 16;
    }

    protected int getDurabilityUse(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack thisStack = player.getItemInHand(hand);
        if (FlintlockItem.isDuelWielding((LivingEntity)player) && (!player.getProjectile(thisStack).isEmpty() || player.hasInfiniteMaterials())) {
            ItemStack mainStack = player.getMainHandItem();
            ItemStack offStack = player.getOffhandItem();
            if (!FlintlockItem.isLoaded(mainStack) && FlintlockItem.isLoaded(offStack)) {
                player.startUsingItem(InteractionHand.MAIN_HAND);
                return InteractionResultHolder.consume((Object)thisStack);
            }
            if (FlintlockItem.isLoaded(mainStack) && !FlintlockItem.isLoaded(offStack)) {
                player.startUsingItem(InteractionHand.OFF_HAND);
                return InteractionResultHolder.consume((Object)thisStack);
            }
            if (FlintlockItem.isLoaded(mainStack) && FlintlockItem.isLoaded(offStack)) {
                this.performShooting(level, (LivingEntity)player, hand, mainStack, 3.6f, 1.0f, null);
                return InteractionResultHolder.consume((Object)thisStack);
            }
            player.startUsingItem(InteractionHand.MAIN_HAND);
            return InteractionResultHolder.consume((Object)thisStack);
        }
        if (player.getProjectile(thisStack).isEmpty() && !player.hasInfiniteMaterials() && !FlintlockItem.isLoaded(thisStack)) {
            return InteractionResultHolder.pass((Object)thisStack);
        }
        if (FlintlockItem.isLoaded(thisStack)) {
            this.performShooting(level, (LivingEntity)player, hand, thisStack, 3.6f, 1.0f, null);
            return InteractionResultHolder.consume((Object)thisStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)thisStack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack thisStack, int remaining) {
        if (!level.isClientSide) {
            int useDuration = this.getUseDuration(thisStack, livingEntity);
            if (remaining == useDuration / 2) {
                level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEventRegistry.FLINTLOCK_CLICK, livingEntity.getSoundSource(), 1.0f, 1.0f);
            }
            if (FlintlockItem.isDuelWielding(livingEntity) && livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                InteractionHand otherHand = player.getUsedItemHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                ItemStack notUsingStack = player.getItemInHand(otherHand);
                if (remaining == useDuration / 2 && FlintlockItem.isLoaded(notUsingStack)) {
                    this.performShooting(level, (LivingEntity)player, otherHand, notUsingStack, 3.6f, 1.0f, null);
                }
                if (remaining <= 6 && this.tryLoadProjectiles(livingEntity, thisStack, livingEntity.getProjectile(thisStack))) {
                    level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEventRegistry.FLINTLOCK_LOAD, livingEntity.getSoundSource(), 0.8f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
                    livingEntity.stopUsingItem();
                }
            } else if (remaining <= 1 && this.tryLoadProjectiles(livingEntity, thisStack, livingEntity.getProjectile(thisStack))) {
                level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEventRegistry.FLINTLOCK_LOAD, livingEntity.getSoundSource(), 0.8f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (FlintlockItem.isLoaded(stack)) {
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEventRegistry.FLINTLOCK_CLICK, livingEntity.getSoundSource(), 0.8f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private boolean tryLoadProjectiles(LivingEntity shooter, ItemStack stack, ItemStack ammo) {
        List list = FlintlockItem.draw((ItemStack)stack, (ItemStack)ammo, (LivingEntity)shooter);
        if (!list.isEmpty()) {
            stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)list));
            return true;
        }
        return false;
    }

    public static boolean isLoaded(ItemStack stack) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        return !chargedprojectiles.isEmpty();
    }

    public static boolean isDuelWielding(LivingEntity entity) {
        return entity.getMainHandItem().is(ItemRegistry.FLINTLOCK) && entity.getOffhandItem().is(ItemRegistry.FLINTLOCK);
    }

    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return ((Item)ItemRegistry.IRON_ROUND.get()).getDefaultInstance();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return FlintlockItem.isDuelWielding(entity) ? 24 : 28;
    }

    public boolean useOnRelease(ItemStack stack) {
        return stack.is((Item)this);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 15;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(Items.IRON_INGOT);
    }
}

