/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items.weapons;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.entities.item.ThrownOilPot;
import xyz.yfrostyf.toxony.items.OilPotItem;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class OilPotSashItem
extends Item
implements ProjectileItem {
    public OilPotSashItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        OilPotItem oilPotItem;
        ItemStack otherStack;
        ItemStack thisStack = player.getItemInHand(hand);
        ItemStack itemStack = otherStack = hand == InteractionHand.MAIN_HAND ? player.getOffhandItem() : player.getMainHandItem();
        if (otherStack.is((Item)this)) {
            return InteractionResultHolder.pass((Object)thisStack);
        }
        boolean canRefillOil = thisStack.has(DataComponentsRegistry.OIL) && otherStack.is(TagRegistry.CAN_REFILL_OIL) && thisStack.getDamageValue() > 0;
        boolean canThrow = thisStack.has(DataComponentsRegistry.OIL) && thisStack.getDamageValue() < thisStack.getMaxDamage();
        Item item = otherStack.getItem();
        if (item instanceof OilPotItem && !(oilPotItem = (OilPotItem)item).getItemOil().isEmpty()) {
            thisStack.set(DataComponentsRegistry.OIL, (Object)oilPotItem.getItemOil());
            thisStack.setDamageValue(0);
            otherStack.consume(1, (LivingEntity)player);
            player.playSound(SoundEvents.BOTTLE_FILL);
            return InteractionResultHolder.sidedSuccess((Object)thisStack, (boolean)level.isClientSide());
        }
        if (canRefillOil) {
            thisStack.setDamageValue(0);
            player.playSound(SoundEvents.BOTTLE_FILL);
            otherStack.consume(1, (LivingEntity)player);
            return InteractionResultHolder.sidedSuccess((Object)thisStack, (boolean)level.isClientSide());
        }
        if (canThrow) {
            if (!level.isClientSide) {
                ThrownOilPot thrownOilPot = new ThrownOilPot(level, (LivingEntity)player, thisStack);
                thrownOilPot.setItem(thisStack);
                thrownOilPot.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
                level.addFreshEntity((Entity)thrownOilPot);
            }
            player.getCooldowns().addCooldown(thisStack.getItem(), 30);
            if (!player.hasInfiniteMaterials()) {
                thisStack.setDamageValue(thisStack.getDamageValue() + 1);
            }
            player.playSound(SoundEvents.SPLASH_POTION_THROW);
            return InteractionResultHolder.sidedSuccess((Object)thisStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)thisStack);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        ThrownOilPot thrownOilPot = new ThrownOilPot(level, stack, pos.x(), pos.y(), pos.z());
        thrownOilPot.setItem(stack);
        return thrownOilPot;
    }

    public String getDescriptionId(ItemStack stack) {
        if (stack.has(DataComponentsRegistry.OIL)) {
            return this.getDescriptionId() + ".effect." + ((ItemOil)stack.get(DataComponentsRegistry.OIL)).oil().getKey().location().getPath();
        }
        return super.getDescriptionId();
    }
}

