/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.items.weapons;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import xyz.yfrostyf.toxony.api.items.ToxFueledItem;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;

public class WitchingBladeItem
extends ToxFueledItem {
    private static final float MAX_BONUS_DAMAGE = 10.0f;

    public WitchingBladeItem(Item.Properties properties, int tickrate, int cooldown, SoundEvent sound) {
        super(properties.component(DataComponents.TOOL, (Object)WitchingBladeItem.createToolProperties()), tickrate, cooldown, sound);
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        ServerPlayer svplayer;
        block5: {
            block4: {
                ItemStack item = damageSource.getWeaponItem();
                Entity entity = damageSource.getEntity();
                if (item == null || !(entity instanceof ServerPlayer)) break block4;
                svplayer = (ServerPlayer)entity;
                if (WitchingBladeItem.isActive(item)) break block5;
            }
            return 0.0f;
        }
        if (!svplayer.hasData(DataAttachmentRegistry.TOX_DATA)) {
            return 0.0f;
        }
        float plyTox = ((ToxData)svplayer.getData(DataAttachmentRegistry.TOX_DATA)).getTox();
        return Math.clamp(plyTox / 100.0f, 0.0f, 10.0f);
    }

    public static ItemAttributeModifiers createAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)), 1.0f, 2);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(itemAbility);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 15;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(Items.IRON_INGOT);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ToxFueledItem.Builder {
        @Override
        public WitchingBladeItem build() {
            return new WitchingBladeItem(this.properties, this.tickrate, this.cooldown, this.sound);
        }
    }
}

