/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.jei;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.recipes.AlchemicalForgeRecipe;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class AlchemicalForgeRecipeCatagory
implements IRecipeCategory<AlchemicalForgeRecipe> {
    public static final RecipeType<AlchemicalForgeRecipe> ALCHEMICAL_FORGE_RECIPE = RecipeType.create((String)"toxony", (String)"alchemical_forge", AlchemicalForgeRecipe.class);
    public static final ResourceLocation AFFINITY_ICONS = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/affinity_icons.png");
    private final int IMAGE_WIDTH = 176;
    private final int IMAGE_HEIGHT = 166;
    private final IDrawable icon;
    private final IDrawableStatic background;

    public AlchemicalForgeRecipeCatagory(IGuiHelper guiHelper) {
        ResourceLocation alchemical_forge_menu = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/jei/alchemical_forge_menu_jei.png");
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ItemRegistry.ALCHEMICAL_FORGE_PART.get()));
        this.background = guiHelper.createDrawable(alchemical_forge_menu, 0, 0, 176, 166);
    }

    public RecipeType<AlchemicalForgeRecipe> getRecipeType() {
        return ALCHEMICAL_FORGE_RECIPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.toxony.alchemical_forge");
    }

    public void draw(AlchemicalForgeRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 1);
        List<Affinity> affinities = recipe.getAffinities();
        int factorBasedOnSize = (affinities.size() - 1) * 8;
        int i = 0;
        for (Affinity affinity : affinities) {
            guiGraphics.blit(AFFINITY_ICONS, 82 - factorBasedOnSize + i * 15, 9, (float)(affinity.getIndex() * 13), (float)((int)((double)(affinity.getIndex() / 4) * 13.0)), 13, 13, 52, 39);
            ++i;
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlchemicalForgeRecipe recipe, IFocusGroup focuses) {
        Ingredient mainingredient = recipe.getMainIngredient();
        Pair<Ingredient, Ingredient> auxIngredients = recipe.getAuxIngredients();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 80, 44).addIngredients(mainingredient)).setSlotName("mainInputSlot");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 54, 44).addIngredients((Ingredient)auxIngredients.getFirst())).setSlotName("auxInputSlot1");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 106, 44).addIngredients((Ingredient)auxIngredients.getSecond())).setSlotName("auxInputSlot2");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 94).addItemStack(recipe.getResultItem(null))).setSlotName("outputSlot");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 166;
    }
}

