/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.jei;

import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.recipes.AlembicRecipe;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class AlembicRecipeCatagory
implements IRecipeCategory<AlembicRecipe> {
    public static final RecipeType<AlembicRecipe> ALEMBIC_RECIPE = RecipeType.create((String)"toxony", (String)"alembic", AlembicRecipe.class);
    private final int IMAGE_WIDTH = 176;
    private final int IMAGE_HEIGHT = 166;
    private final IDrawable icon;
    private final IDrawableStatic background;
    private final IDrawableAnimated bubbles;
    private final IDrawableAnimated progressBar;

    public AlembicRecipeCatagory(IGuiHelper guiHelper) {
        ResourceLocation alembic_menu = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/jei/alembic_menu_jei.png");
        ResourceLocation alembic_bubbles = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/sprites/container/bubbles.png");
        ResourceLocation progress_bar = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/sprites/container/progress_bar.png");
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ItemRegistry.ALEMBIC.get()));
        this.background = guiHelper.createDrawable(alembic_menu, 0, 0, 176, 166);
        this.bubbles = guiHelper.drawableBuilder(alembic_bubbles, 0, 0, 10, 27).setTextureSize(10, 27).buildAnimated((ITickTimer)new AlembicBubblesTickTimer(guiHelper), IDrawableAnimated.StartDirection.BOTTOM);
        this.progressBar = guiHelper.drawableBuilder(progress_bar, 0, 0, 3, 25).setTextureSize(3, 25).buildAnimated(guiHelper.createTickTimer(300, 25, true), IDrawableAnimated.StartDirection.BOTTOM);
    }

    public RecipeType<AlembicRecipe> getRecipeType() {
        return ALEMBIC_RECIPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.toxony.alembic");
    }

    public void draw(AlembicRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 1);
        this.bubbles.draw(guiGraphics, 52, 34);
        this.progressBar.draw(guiGraphics, 140, 42);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlembicRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 77, 52).addIngredients(recipe.getIngredient())).setSlotName("inputSlot");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 113, 47).addIngredients(recipe.getIngredientToConvert())).setSlotName("inputSlotConvert");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 12).addItemStack(recipe.getResultItem(null))).setSlotName("outputSlot");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 166;
    }

    private static class AlembicBubblesTickTimer
    implements ITickTimer {
        private static final int[] BUBBLE_LENGTHS = new int[]{27, 24, 20, 16, 11, 6, 0};
        private final ITickTimer internalTimer;

        public AlembicBubblesTickTimer(IGuiHelper guiHelper) {
            this.internalTimer = guiHelper.createTickTimer(14, BUBBLE_LENGTHS.length - 1, false);
        }

        public int getValue() {
            int timerValue = this.internalTimer.getValue();
            return BUBBLE_LENGTHS[timerValue];
        }

        public int getMaxValue() {
            return BUBBLE_LENGTHS[0];
        }
    }
}

