/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.jei;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.recipes.CrucibleRecipe;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class CrucibleRecipeCatagory
implements IRecipeCategory<CrucibleRecipe> {
    public static final RecipeType<CrucibleRecipe> CRUCIBLE_RECIPE = RecipeType.create((String)"toxony", (String)"crucible", CrucibleRecipe.class);
    private final int IMAGE_WIDTH = 176;
    private final int IMAGE_HEIGHT = 166;
    private final IDrawable icon;
    private final IDrawableStatic background;
    protected final IDrawableAnimated flames;
    protected final IDrawableAnimated progressBar;

    public CrucibleRecipeCatagory(IGuiHelper guiHelper) {
        ResourceLocation crucible_menu = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/jei/copper_crucible_menu_jei.png");
        ResourceLocation crucible_flames = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/sprites/container/crucible_flames.png");
        ResourceLocation progress_bar = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/sprites/container/progress_bar.png");
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ItemRegistry.COPPER_CRUCIBLE.get()));
        this.background = guiHelper.createDrawable(crucible_menu, 0, 0, 176, 166);
        this.flames = guiHelper.drawableBuilder(crucible_flames, 0, 0, 13, 11).setTextureSize(13, 11).buildAnimated(400, IDrawableAnimated.StartDirection.TOP, true);
        this.progressBar = guiHelper.drawableBuilder(progress_bar, 0, 0, 3, 25).setTextureSize(3, 25).buildAnimated(300, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public RecipeType<CrucibleRecipe> getRecipeType() {
        return CRUCIBLE_RECIPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.toxony.copper_crucible");
    }

    public void draw(CrucibleRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 1);
        this.progressBar.draw(guiGraphics, 115, 18);
        this.flames.draw(guiGraphics, 82, 45);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrucibleRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 80, 22).addIngredients((Ingredient)recipe.getIngredients().getFirst())).setSlotName("inputSlot");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 22).addItemStack(recipe.getResultItem(null))).setSlotName("outputSlot");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 166;
    }
}

