/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import xyz.yfrostyf.toxony.client.gui.block.AlembicScreen;
import xyz.yfrostyf.toxony.client.gui.block.CopperCrucibleScreen;
import xyz.yfrostyf.toxony.jei.AlchemicalForgeRecipeCatagory;
import xyz.yfrostyf.toxony.jei.AlembicRecipeCatagory;
import xyz.yfrostyf.toxony.jei.CrucibleRecipeCatagory;
import xyz.yfrostyf.toxony.jei.MortarPestleRecipeCatagory;
import xyz.yfrostyf.toxony.recipes.AlchemicalForgeRecipe;
import xyz.yfrostyf.toxony.recipes.AlembicRecipe;
import xyz.yfrostyf.toxony.recipes.CrucibleRecipe;
import xyz.yfrostyf.toxony.recipes.MortarPestleRecipe;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

@JeiPlugin
public class ToxonyJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MortarPestleRecipeCatagory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCatagory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlembicRecipeCatagory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemicalForgeRecipeCatagory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        List mortarPestleRecipeHolders = manager.getAllRecipesFor(RecipeRegistry.MORTAR_PESTLE_RECIPE.get());
        List<MortarPestleRecipe> mortarPestleRecipes = mortarPestleRecipeHolders.stream().map(holder -> (MortarPestleRecipe)holder.value()).toList();
        registration.addRecipes(MortarPestleRecipeCatagory.MORTAR_PESTLE_RECIPE, mortarPestleRecipes);
        List crucibleRecipeHolders = manager.getAllRecipesFor(RecipeRegistry.CRUCIBLE_RECIPE.get());
        List<CrucibleRecipe> crucibleRecipes = crucibleRecipeHolders.stream().map(holder -> (CrucibleRecipe)holder.value()).toList();
        registration.addRecipes(CrucibleRecipeCatagory.CRUCIBLE_RECIPE, crucibleRecipes);
        List alembicRecipeHolders = manager.getAllRecipesFor(RecipeRegistry.ALEMBIC_RECIPE.get());
        List<AlembicRecipe> alembicRecipes = alembicRecipeHolders.stream().map(holder -> (AlembicRecipe)holder.value()).toList();
        registration.addRecipes(AlembicRecipeCatagory.ALEMBIC_RECIPE, alembicRecipes);
        List alchemicalForgeRecipeHolders = manager.getAllRecipesFor(RecipeRegistry.ALCHEMICAL_FORGE_RECIPE.get());
        List<AlchemicalForgeRecipe> alchemicalForgeRecipes = alchemicalForgeRecipeHolders.stream().map(holder -> (AlchemicalForgeRecipe)holder.value()).toList();
        registration.addRecipes(AlchemicalForgeRecipeCatagory.ALCHEMICAL_FORGE_RECIPE, alchemicalForgeRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CopperCrucibleScreen.class, 115, 27, 2, 2, new RecipeType[]{CrucibleRecipeCatagory.CRUCIBLE_RECIPE});
        registration.addRecipeClickArea(AlembicScreen.class, 122, 31, 2, 2, new RecipeType[]{AlembicRecipeCatagory.ALEMBIC_RECIPE});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.MORTAR_PESTLE.get()), new RecipeType[]{MortarPestleRecipeCatagory.MORTAR_PESTLE_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.COPPER_CRUCIBLE.get()), new RecipeType[]{CrucibleRecipeCatagory.CRUCIBLE_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ALEMBIC.get()), new RecipeType[]{AlembicRecipeCatagory.ALEMBIC_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ALCHEMICAL_FORGE_PART.get()), new RecipeType[]{AlchemicalForgeRecipeCatagory.ALCHEMICAL_FORGE_RECIPE});
    }
}

