/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.yfrostyf.toxony.client.gui.NightPredatorOverlay;

public record ServerNightPredatorPacket(boolean isStarting) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerNightPredatorPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"night_predator"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerNightPredatorPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ServerNightPredatorPacket::isStarting, ServerNightPredatorPacket::new);

    public static ServerNightPredatorPacket create(boolean isStarting) {
        return new ServerNightPredatorPacket(isStarting);
    }

    public static void handle(ServerNightPredatorPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!context.player().level().isClientSide()) {
                return;
            }
            if (packet.isStarting) {
                NightPredatorOverlay.startAnimation();
            } else {
                NightPredatorOverlay.endAnimation();
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

