/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerSendMessagePacket(String componentID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerSendMessagePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"send_message"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerSendMessagePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ServerSendMessagePacket::componentID, ServerSendMessagePacket::new);

    public static ServerSendMessagePacket create(String componentID) {
        return new ServerSendMessagePacket(componentID);
    }

    public static void handle(ServerSendMessagePacket messagePacket, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!context.player().level().isClientSide()) {
                return;
            }
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)messagePacket.componentID), false);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

