/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.client.ClientIngredientAffinityMapData;
import xyz.yfrostyf.toxony.data.world.IngredientAffinityMapData;

public record SyncIngredientAffinityMapPacket(Map<String, Affinity> map) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncIngredientAffinityMapPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"sync_affinity_map"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncIngredientAffinityMapPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, Affinity.STREAM_CODEC), SyncIngredientAffinityMapPacket::map, SyncIngredientAffinityMapPacket::new);

    public static SyncIngredientAffinityMapPacket create(Map<ResourceLocation, Affinity> map) {
        HashMap<String, Affinity> newMap = new HashMap<String, Affinity>();
        for (Map.Entry<ResourceLocation, Affinity> entry : map.entrySet()) {
            newMap.put(entry.getKey().toString(), entry.getValue());
        }
        return new SyncIngredientAffinityMapPacket(newMap);
    }

    public static void handle(SyncIngredientAffinityMapPacket syncIngredientAffinityMapPacket, IPayloadContext context) {
        context.enqueueWork(() -> {
            HashMap<ResourceLocation, Affinity> newMap = new HashMap<ResourceLocation, Affinity>();
            for (Map.Entry<String, Affinity> entry : syncIngredientAffinityMapPacket.map.entrySet()) {
                newMap.put(ResourceLocation.parse((String)entry.getKey()), entry.getValue());
            }
            ClientIngredientAffinityMapData.setData(IngredientAffinityMapData.create(newMap));
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"toxony.networking.sync_affinity_map.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

