/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.yfrostyf.toxony.api.mutagens.MutagenData;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;

public record SyncMutagenDataPacket(Map<String, Boolean> booleanMap, Map<String, Integer> integerMap) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncMutagenDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"sync_mutagen_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncMutagenDataPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.BOOL, (int)256), SyncMutagenDataPacket::booleanMap, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.INT, (int)256), SyncMutagenDataPacket::integerMap, SyncMutagenDataPacket::new);

    public static SyncMutagenDataPacket create(MutagenData mutagenData) {
        return new SyncMutagenDataPacket(mutagenData.getBooleanMap(), mutagenData.getIntegerMap());
    }

    public static void handle(SyncMutagenDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> context.player().setData(DataAttachmentRegistry.MUTAGEN_DATA, (Object)new MutagenData(packet.booleanMap, packet.integerMap))).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"toxony.networking.sync_tox_data.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

