/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.yfrostyf.toxony.api.client.ClientToxData;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;

public record SyncToxPacket(int tox) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncToxPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"sync_tox"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncToxPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SyncToxPacket::tox, SyncToxPacket::new);

    public static SyncToxPacket create(float tox) {
        return new SyncToxPacket((int)tox);
    }

    public static void handle(SyncToxPacket syncToxPacket, IPayloadContext context) {
        context.enqueueWork(() -> {
            context.player().getData(DataAttachmentRegistry.TOX_DATA);
            ClientToxData.changeTox(syncToxPacket.tox);
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"toxony.networking.sync_tox.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

