/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.api.registries.ToxonyRegistries;
import xyz.yfrostyf.toxony.api.util.AffinityUtil;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class AffinityIngredient
implements ICustomIngredient {
    private final Affinity affinity;
    public static final MapCodec<AffinityIngredient> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ToxonyRegistries.AFFINITY_REGISTRY.byNameCodec().fieldOf("affinity").forGetter(e -> e.affinity)).apply((Applicative)inst, AffinityIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AffinityIngredient> STREAM_CODEC = StreamCodec.composite(Affinity.STREAM_CODEC, e -> e.affinity, AffinityIngredient::new);

    public AffinityIngredient(Affinity affinity) {
        this.affinity = affinity;
    }

    public boolean test(ItemStack stack) {
        return stack.has((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get()) && AffinityUtil.readAffinityFromIngredientMap(stack).equals(this.affinity);
    }

    public boolean isSimple() {
        return false;
    }

    public Stream<ItemStack> getItems() {
        List<ItemStack> stacks = BuiltInRegistries.ITEM.stream().filter(item -> item.components().has((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get()) && ((List)item.components().get((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get())).contains(this.affinity)).map(ItemStack::new).toList();
        return stacks.stream();
    }

    public IngredientType<?> getType() {
        return RecipeRegistry.AFFINITY.get();
    }
}

