/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.api.util.AffinityUtil;
import xyz.yfrostyf.toxony.recipes.inputs.AlchemicalForgeRecipeInput;
import xyz.yfrostyf.toxony.registries.AffinityRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class AlchemicalForgeRecipe
implements Recipe<AlchemicalForgeRecipeInput> {
    final ItemStack outputItem;
    final Ingredient mainIngredientRecipe;
    final List<Affinity> affinitiesRecipe;
    final List<Ingredient> auxIngredientsRecipe;

    public AlchemicalForgeRecipe(ItemStack outputItem, Ingredient mainIngredientRecipe, List<Affinity> affinitiesRecipe, List<Ingredient> auxIngredientsRecipe) {
        this.outputItem = outputItem;
        this.mainIngredientRecipe = mainIngredientRecipe;
        this.affinitiesRecipe = affinitiesRecipe;
        this.auxIngredientsRecipe = auxIngredientsRecipe;
    }

    public boolean matches(AlchemicalForgeRecipeInput input, Level level) {
        if (input.getSolutions().isEmpty() || input.getMainItem().isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> inputAuxIngredients = new ArrayList<ItemStack>(input.getAuxItems());
        List inputAffinities = input.getSolutions().stream().map(holder -> AffinityUtil.readAffinityFromIngredientMap(new ItemStack((Holder)holder.getOrDefault(DataComponentsRegistry.AFFINITY_STORED_ITEM, (Object)ItemStack.EMPTY.getItemHolder())), level)).collect(Collectors.toCollection(ArrayList::new));
        for (Affinity affinity : this.affinitiesRecipe) {
            if (inputAffinities.contains(affinity)) {
                inputAffinities.remove(affinity);
                continue;
            }
            return false;
        }
        for (Ingredient ingredient : this.auxIngredientsRecipe) {
            boolean found = false;
            for (int i = 0; i < inputAuxIngredients.size(); ++i) {
                if (!ingredient.test((ItemStack)inputAuxIngredients.get(i))) continue;
                inputAuxIngredients.remove(i);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return this.mainIngredientRecipe.test(input.getMainItem());
    }

    public ItemStack assemble(AlchemicalForgeRecipeInput input, HolderLookup.Provider registries) {
        return this.outputItem.copy();
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height < 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.outputItem.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.createWithCapacity((int)3);
        nonnulllist.add((Object)this.mainIngredientRecipe);
        for (Ingredient ingredient : this.auxIngredientsRecipe) {
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public Ingredient getMainIngredient() {
        return this.mainIngredientRecipe;
    }

    public List<Affinity> getAffinities() {
        return this.affinitiesRecipe;
    }

    public Pair<Ingredient, Ingredient> getAuxIngredients() {
        if (this.auxIngredientsRecipe.isEmpty()) {
            return new Pair((Object)Ingredient.EMPTY, (Object)Ingredient.EMPTY);
        }
        if (this.auxIngredientsRecipe.size() == 1) {
            return new Pair((Object)this.auxIngredientsRecipe.getFirst(), (Object)Ingredient.EMPTY);
        }
        return new Pair((Object)this.auxIngredientsRecipe.get(0), (Object)this.auxIngredientsRecipe.get(1));
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.ALCHEMICAL_FORGE_RECIPE.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeRegistry.ALCHEMICAL_FORGE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<AlchemicalForgeRecipe> {
        public static final MapCodec<AlchemicalForgeRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(r -> r.outputItem), (App)Ingredient.CODEC_NONEMPTY.fieldOf("main").forGetter(r -> r.mainIngredientRecipe), (App)((Registry)AffinityRegistry.AFFINITIES.getRegistry().get()).byNameCodec().listOf().fieldOf("affinities").forGetter(r -> r.affinitiesRecipe), (App)Ingredient.LIST_CODEC.fieldOf("auxiliary").forGetter(r -> r.auxIngredientsRecipe)).apply((Applicative)inst, AlchemicalForgeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlchemicalForgeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<AlchemicalForgeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlchemicalForgeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, AlchemicalForgeRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputItem);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.mainIngredientRecipe);
            Affinity.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.affinitiesRecipe);
            Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.auxIngredientsRecipe);
        }

        private static AlchemicalForgeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient main = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            List affinities = (List)Affinity.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer);
            List aux = (List)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer);
            return new AlchemicalForgeRecipe(itemstack, main, affinities, aux);
        }
    }
}

