/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.recipes.inputs.PairCombineRecipeInput;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class AlembicRecipe
implements Recipe<PairCombineRecipeInput> {
    final ItemStack outputItem;
    final ItemStack remainingingItem;
    final Ingredient recipeIngredient;
    final Ingredient recipeIngredientToConvert;
    final int boilTime;

    public AlembicRecipe(ItemStack outputItem, Ingredient recipeIngredient, Ingredient recipeIngredientToConvert, int boilTime, Optional<ItemStack> remainingingItem) {
        this.outputItem = outputItem;
        this.recipeIngredient = recipeIngredient;
        this.recipeIngredientToConvert = recipeIngredientToConvert;
        this.boilTime = boilTime;
        this.remainingingItem = remainingingItem.orElse(ItemStack.EMPTY);
    }

    public boolean matches(PairCombineRecipeInput input, Level level) {
        if (input.getItem(0).isEmpty() || input.getItemToConvert().isEmpty()) {
            return false;
        }
        return this.recipeIngredient.test(input.getItem(0)) && this.recipeIngredientToConvert.test(input.getItemToConvert());
    }

    public ItemStack assemble(PairCombineRecipeInput input, HolderLookup.Provider registries) {
        return this.outputItem.copy();
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height < 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.outputItem.copy();
    }

    public ItemStack getRemainingingItem() {
        return this.remainingingItem.copy();
    }

    public Ingredient getIngredient() {
        return this.recipeIngredient;
    }

    public Ingredient getIngredientToConvert() {
        return this.recipeIngredientToConvert;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.createWithCapacity((int)2);
        nonnulllist.add((Object)this.recipeIngredient);
        nonnulllist.add((Object)this.recipeIngredientToConvert);
        return nonnulllist;
    }

    public int getBoilTime() {
        return this.boilTime;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.ALEMBIC_RECIPE.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeRegistry.ALEMBIC_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<AlembicRecipe> {
        public static final MapCodec<AlembicRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.outputItem), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(r -> r.recipeIngredient), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient_to_convert").forGetter(r -> r.recipeIngredientToConvert), (App)Codec.INT.fieldOf("boiltime").orElse((Object)200).forGetter(r -> r.boilTime), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.optionalFieldOf("remaining").forGetter(r -> r.remainingingItem != ItemStack.EMPTY ? Optional.of(r.remainingingItem) : Optional.empty())).apply((Applicative)inst, AlembicRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlembicRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<AlembicRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlembicRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, AlembicRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputItem);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.recipeIngredient);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.recipeIngredientToConvert);
            buffer.writeVarInt(recipe.boilTime);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.remainingingItem);
        }

        private static AlembicRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient ingredientToConvert = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int boilTime = buffer.readVarInt();
            ItemStack remaining = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new AlembicRecipe(itemstack, ingredient, ingredientToConvert, boilTime, Optional.of(remaining));
        }
    }
}

