/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class CrucibleRecipe
implements Recipe<SingleRecipeInput> {
    final ItemStack outputItem;
    final Ingredient ingredient;
    final int cookTime;

    public CrucibleRecipe(ItemStack outputItem, Ingredient ingredient, int cookTime) {
        this.outputItem = outputItem;
        this.ingredient = ingredient;
        this.cookTime = cookTime;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        if (this.ingredient == null) {
            return false;
        }
        return this.ingredient.test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return this.outputItem.copy();
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height < 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.outputItem.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.CRUCIBLE_RECIPE.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeRegistry.CRUCIBLE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<CrucibleRecipe> {
        public static final MapCodec<CrucibleRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.outputItem), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)Codec.INT.fieldOf("cooktime").orElse((Object)200).forGetter(r -> r.cookTime)).apply((Applicative)inst, CrucibleRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CrucibleRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CrucibleRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrucibleRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, CrucibleRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputItem);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeVarInt(recipe.cookTime);
        }

        private static CrucibleRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int cookingTime = buffer.readVarInt();
            return new CrucibleRecipe(itemstack, ingredient, cookingTime);
        }
    }
}

