/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class MortarPestleRecipe
implements Recipe<RecipeWrapper> {
    final ItemStack outputItem;
    final NonNullList<Ingredient> recipeIngredients;
    final Optional<ItemStack> useItem;

    public MortarPestleRecipe(ItemStack outputItem, Optional<ItemStack> useItem, NonNullList<Ingredient> recipeIngredients) {
        this.outputItem = outputItem;
        this.useItem = useItem;
        this.recipeIngredients = recipeIngredients;
    }

    public boolean matches(RecipeWrapper input, Level level) {
        if (input.size() != this.recipeIngredients.size()) {
            return false;
        }
        ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.size());
        for (int i = 0; i < input.size(); ++i) {
            ItemStack item = input.getItem(i);
            if (item.isEmpty()) continue;
            nonEmptyItems.add(item);
        }
        return RecipeMatcher.findMatches(nonEmptyItems, this.recipeIngredients) != null;
    }

    public ItemStack assemble(RecipeWrapper input, HolderLookup.Provider registries) {
        return this.outputItem.copy();
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.recipeIngredients.size();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.outputItem.copy();
    }

    public ItemStack getResultItem() {
        return this.outputItem.copy();
    }

    public Optional<ItemStack> getUseItem() {
        return this.useItem;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeIngredients;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.MORTAR_PESTLE_RECIPE.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeRegistry.MORTAR_PESTLE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<MortarPestleRecipe> {
        public static final MapCodec<MortarPestleRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.outputItem), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.optionalFieldOf("use").forGetter(r -> r.useItem), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").xmap(ingredients -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return nonNullList;
        }, ingredients -> ingredients).forGetter(MortarPestleRecipe::getIngredients)).apply((Applicative)inst, MortarPestleRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MortarPestleRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<MortarPestleRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MortarPestleRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, MortarPestleRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputItem);
            ItemStack.STREAM_CODEC.apply(ByteBufCodecs::optional).encode((Object)buffer, recipe.useItem);
            buffer.writeVarInt(recipe.recipeIngredients.size());
            for (Ingredient ingredient : recipe.recipeIngredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
        }

        private static MortarPestleRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Optional usestack = (Optional)ItemStack.STREAM_CODEC.apply(ByteBufCodecs::optional).decode((Object)buffer);
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(in -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            return new MortarPestleRecipe(itemstack, usestack, (NonNullList<Ingredient>)nonnulllist);
        }
    }
}

