/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.registries;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import xyz.yfrostyf.toxony.entities.GuidedSpiritEntity;
import xyz.yfrostyf.toxony.entities.item.Bolt;
import xyz.yfrostyf.toxony.entities.item.FlailBall;
import xyz.yfrostyf.toxony.entities.item.FlintlockBall;
import xyz.yfrostyf.toxony.entities.item.SmokeBolt;
import xyz.yfrostyf.toxony.entities.item.ThrownOilPot;
import xyz.yfrostyf.toxony.entities.item.ToxicCakeProjectile;
import xyz.yfrostyf.toxony.entities.item.WitchFireBolt;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"toxony");
    public static final DeferredHolder<EntityType<?>, EntityType<GuidedSpiritEntity>> GUIDED_SPIRIT = ENTITIES.register("guided_spirit", () -> EntityType.Builder.of(GuidedSpiritEntity::new, (MobCategory)MobCategory.CREATURE).fireImmune().sized(0.3f, 0.4f).eyeHeight(0.5f).clientTrackingRange(8).build("guided_spirit"));
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownOilPot>> OIL_POT = ENTITIES.register("oil_pot", () -> EntityType.Builder.of(ThrownOilPot::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(10).build("oil_pot"));
    public static final DeferredHolder<EntityType<?>, EntityType<Bolt>> BOLT = ENTITIES.register("bolt", () -> EntityType.Builder.of(Bolt::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(10).build("bolt"));
    public static final DeferredHolder<EntityType<?>, EntityType<SmokeBolt>> SMOKE_BOLT = ENTITIES.register("smoke_cycle_bolt", () -> EntityType.Builder.of(SmokeBolt::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(10).build("smoke_cycle_bolt"));
    public static final DeferredHolder<EntityType<?>, EntityType<WitchFireBolt>> WITCHFIRE_BOLT = ENTITIES.register("witchfire_bolt", () -> EntityType.Builder.of(WitchFireBolt::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(10).build("witchfire_bolt"));
    public static final DeferredHolder<EntityType<?>, EntityType<FlailBall>> FLAIL_BALL = ENTITIES.register("flail_ball", () -> EntityType.Builder.of(FlailBall::new, (MobCategory)MobCategory.MISC).noSave().noSummon().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(3).build("flail_ball"));
    public static final DeferredHolder<EntityType<?>, EntityType<FlintlockBall>> FLINTLOCK_BALL = ENTITIES.register("flintlock_ball", () -> EntityType.Builder.of(FlintlockBall::new, (MobCategory)MobCategory.MISC).noSave().noSummon().sized(0.2f, 0.2f).clientTrackingRange(5).updateInterval(2).build("flintlock_ball"));
    public static final DeferredHolder<EntityType<?>, EntityType<ToxicCakeProjectile>> TOXIC_CAKE_PROJECTILE = ENTITIES.register("toxic_cake_projectile", () -> EntityType.Builder.of(ToxicCakeProjectile::new, (MobCategory)MobCategory.MISC).sized(0.3f, 0.3f).clientTrackingRange(4).updateInterval(10).build("toxic_cake_projectile"));

    public static void register(IEventBus eventBus) {
        ENTITIES.register(eventBus);
    }
}

