/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.registries;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import xyz.yfrostyf.toxony.recipes.AffinityIngredient;
import xyz.yfrostyf.toxony.recipes.AlchemicalForgeRecipe;
import xyz.yfrostyf.toxony.recipes.AlembicRecipe;
import xyz.yfrostyf.toxony.recipes.CrucibleRecipe;
import xyz.yfrostyf.toxony.recipes.MortarPestleRecipe;
import xyz.yfrostyf.toxony.recipes.PossibleAffinityIngredient;

public class RecipeRegistry {
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"toxony");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"toxony");
    public static final DeferredRegister<IngredientType<?>> INGREDIENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.INGREDIENT_TYPES, (String)"toxony");
    public static final Supplier<RecipeType<MortarPestleRecipe>> MORTAR_PESTLE_RECIPE = RECIPE_TYPES.register("mortar_pestle", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"mortar_pestle")));
    public static final Supplier<RecipeType<CrucibleRecipe>> CRUCIBLE_RECIPE = RECIPE_TYPES.register("crucible", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"crucible")));
    public static final Supplier<RecipeType<AlembicRecipe>> ALEMBIC_RECIPE = RECIPE_TYPES.register("alembic", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"alembic")));
    public static final Supplier<RecipeType<AlchemicalForgeRecipe>> ALCHEMICAL_FORGE_RECIPE = RECIPE_TYPES.register("alchemical_forge", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"alchemical_forge")));
    public static final Supplier<RecipeSerializer<?>> MORTAR_PESTLE_SERIALIZER = RECIPE_SERIALIZERS.register("mortar_pestle", MortarPestleRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> CRUCIBLE_SERIALIZER = RECIPE_SERIALIZERS.register("crucible", CrucibleRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> ALEMBIC_SERIALIZER = RECIPE_SERIALIZERS.register("alembic", AlembicRecipe.Serializer::new);
    public static final Supplier<RecipeSerializer<?>> ALCHEMICAL_FORGE_SERIALIZER = RECIPE_SERIALIZERS.register("alchemical_forge", AlchemicalForgeRecipe.Serializer::new);
    public static final Supplier<IngredientType<PossibleAffinityIngredient>> POSSIBLE_AFFINITY = INGREDIENT_TYPES.register("possible_affinity", () -> new IngredientType(PossibleAffinityIngredient.CODEC, PossibleAffinityIngredient.STREAM_CODEC));
    public static final Supplier<IngredientType<AffinityIngredient>> AFFINITY = INGREDIENT_TYPES.register("affinity", () -> new IngredientType(AffinityIngredient.CODEC, AffinityIngredient.STREAM_CODEC));

    public static void register(IEventBus event) {
        RECIPE_TYPES.register(event);
        RECIPE_SERIALIZERS.register(event);
        INGREDIENT_TYPES.register(event);
    }
}

