/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import xyz.yfrostyf.toxony.blocks.plants.FalseBerryBushBlock;
import xyz.yfrostyf.toxony.blocks.plants.WildPoisonCropBlock;
import xyz.yfrostyf.toxony.registries.BlockRegistry;

public class ToxonyConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_FALSE_BERRY_BUSH = ToxonyConfiguredFeatures.registerKey("patch_false_berry_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_OCELOT_MINT = ToxonyConfiguredFeatures.registerKey("wild_ocelot_mint");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_NIGHTSHADE = ToxonyConfiguredFeatures.registerKey("wild_nightshade");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_WATER_HEMLOCK = ToxonyConfiguredFeatures.registerKey("wild_water_hemlock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_COLDSNAP = ToxonyConfiguredFeatures.registerKey("wild_coldsnap");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_ANCIENT_SILVER_SMALL = ToxonyConfiguredFeatures.registerKey("ore_ancient_silver_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_WILD_BLOODROOT = ToxonyConfiguredFeatures.registerKey("patch_wild_bloodroot");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ToxonyConfiguredFeatures.register(context, PATCH_FALSE_BERRY_BUSH, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)BlockRegistry.FALSE_BERRY_BUSH.get()).defaultBlockState().setValue((Property)FalseBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK)));
        ToxonyConfiguredFeatures.register(context, WILD_OCELOT_MINT, Feature.FLOWER, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)BlockRegistry.WILD_OCELOT_MINT.get()).defaultBlockState().setValue((Property)WildPoisonCropBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK)));
        ToxonyConfiguredFeatures.register(context, WILD_NIGHTSHADE, Feature.FLOWER, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)BlockRegistry.WILD_NIGHTSHADE.get()).defaultBlockState().setValue((Property)WildPoisonCropBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK)));
        ToxonyConfiguredFeatures.register(context, WILD_WATER_HEMLOCK, Feature.FLOWER, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)BlockRegistry.WILD_WATER_HEMLOCK.get()).defaultBlockState().setValue((Property)WildPoisonCropBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK, Blocks.MUD)));
        ToxonyConfiguredFeatures.register(context, WILD_COLDSNAP, Feature.FLOWER, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)BlockRegistry.WILD_COLDSNAP.get()).defaultBlockState().setValue((Property)WildPoisonCropBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.GRASS_BLOCK)));
        ToxonyConfiguredFeatures.register(context, PATCH_WILD_BLOODROOT, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)BlockRegistry.WILD_BLOODROOT.get()).defaultBlockState().setValue((Property)WildPoisonCropBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.CRIMSON_NYLIUM)));
        TagMatchTest deepslateReplaceable = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> overworldAncientSilver = List.of(OreConfiguration.target((RuleTest)deepslateReplaceable, (BlockState)((Block)BlockRegistry.ANCIENT_SILVER.get()).defaultBlockState()));
        ToxonyConfiguredFeatures.register(context, ORE_ANCIENT_SILVER_SMALL, Feature.SCATTERED_ORE, new OreConfiguration(overworldAncientSilver, 2, 1.0f));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

