/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import xyz.yfrostyf.toxony.worldgen.ToxonyConfiguredFeatures;

public class ToxonyPlacedFeature {
    public static final ResourceKey<PlacedFeature> PATCH_FALSE_BERRY_BUSH_PLACED = ToxonyPlacedFeature.registerKey("false_berry_bush_placed");
    public static final ResourceKey<PlacedFeature> WILD_OCELOT_MINT_PLACED = ToxonyPlacedFeature.registerKey("wild_ocelot_mint_placed");
    public static final ResourceKey<PlacedFeature> WILD_NIGHTSHADE_PLACED = ToxonyPlacedFeature.registerKey("wild_nightshade_placed");
    public static final ResourceKey<PlacedFeature> WILD_WATER_HEMLOCK_PLACED = ToxonyPlacedFeature.registerKey("wild_water_hemlock_placed");
    public static final ResourceKey<PlacedFeature> WILD_COLDSNAP_PLACED = ToxonyPlacedFeature.registerKey("wild_coldsnap_placed");
    public static final ResourceKey<PlacedFeature> PATCH_WILD_BLOODROOT_PLACED = ToxonyPlacedFeature.registerKey("wild_bloodroot_placed");
    public static final ResourceKey<PlacedFeature> ORE_ANCIENT_SILVER_SMALL = ToxonyPlacedFeature.registerKey("ore_ancient_silver_small");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ToxonyPlacedFeature.register(context, PATCH_FALSE_BERRY_BUSH_PLACED, configuredFeatures.getOrThrow(ToxonyConfiguredFeatures.PATCH_FALSE_BERRY_BUSH), List.of(RarityFilter.onAverageOnceEvery((int)48), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ToxonyPlacedFeature.register(context, WILD_OCELOT_MINT_PLACED, configuredFeatures.getOrThrow(ToxonyConfiguredFeatures.WILD_OCELOT_MINT), List.of(RarityFilter.onAverageOnceEvery((int)48), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ToxonyPlacedFeature.register(context, WILD_NIGHTSHADE_PLACED, configuredFeatures.getOrThrow(ToxonyConfiguredFeatures.WILD_NIGHTSHADE), List.of(RarityFilter.onAverageOnceEvery((int)48), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ToxonyPlacedFeature.register(context, WILD_WATER_HEMLOCK_PLACED, configuredFeatures.getOrThrow(ToxonyConfiguredFeatures.WILD_WATER_HEMLOCK), List.of(RarityFilter.onAverageOnceEvery((int)48), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ToxonyPlacedFeature.register(context, WILD_COLDSNAP_PLACED, configuredFeatures.getOrThrow(ToxonyConfiguredFeatures.WILD_COLDSNAP), List.of(RarityFilter.onAverageOnceEvery((int)48), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ToxonyPlacedFeature.register(context, PATCH_WILD_BLOODROOT_PLACED, configuredFeatures.getOrThrow(ToxonyConfiguredFeatures.PATCH_WILD_BLOODROOT), List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome()));
        ToxonyPlacedFeature.register(context, ORE_ANCIENT_SILVER_SMALL, configuredFeatures.getOrThrow(ToxonyConfiguredFeatures.ORE_ANCIENT_SILVER_SMALL), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-32)), BiomeFilter.biome()));
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

